/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.soundfloor;

import cn.com.yto56.basic.framework.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.controller.soundfloor.ClientRequestParam;
import com.yto.monitor.adapter.entity.request.SoundFloorRequest;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.service.soundfloor.SoundFloorService;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.Page;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.entity.routesmerge.RequestPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"\u58f0\u97f3\u5206\u5c42\u7ba1\u7406"})
@RestController
@RequestMapping(value={"Yto_MonitorGateway/sound"})
public class SoundFloorController {
    private static final Logger log = LoggerFactory.getLogger(SoundFloorController.class);
    @Autowired
    private SoundFloorService soundFloorService;

    public static boolean validateData(BindingResult result, HttpBaseResponse resp) {
        if (result.hasErrors()) {
            String errorResult = result.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).reduce((o, t) -> o + ";" + t).orElse("\u53c2\u6570\u6709\u8bef");
            resp.setRespMessage(errorResult);
            resp.setRespCode(ResponseTypeEnum.PARAM_FAIL.getRespCode());
            return true;
        }
        return false;
    }

    @HeadTokenVerification
    @PostMapping(value={"addSoundFloor"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u65b0\u589e\u58f0\u97f3\u5206\u5c42", produces="application/json;charset=UTF-8")
    public HttpBaseResponse addSoundFloor(@Validated @RequestBody SoundFloorRequest request, BindingResult result, HttpBaseResponse resp) {
        if (SoundFloorController.validateData((BindingResult)result, (HttpBaseResponse)resp)) {
            return resp;
        }
        boolean insertFlag = this.soundFloorService.insertSoundFloorItem(request);
        if (!insertFlag) {
            resp.setRespMessage("failure");
            resp.setRespCode("000");
            return resp;
        }
        resp.setRespCode("200");
        resp.setRespMessage("\u6210\u529f");
        return resp;
    }

    @HeadTokenVerification
    @PostMapping(value={"validateThreeCode"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6821\u9a8c\u4e09\u6bb5\u7801", produces="application/json;charset=UTF-8")
    public HttpBaseResponse validateThreeCode(@RequestParam(value="threeCode") String threeCode, HttpBaseResponse response) {
        boolean existFlag = this.soundFloorService.querySoundFloorByThreeCode(threeCode);
        if (existFlag) {
            response.setRespMessage(ResponseTypeEnum.DATA_REPEAT.getRespMessage());
            response.setRespCode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            return response;
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage(ResponseTypeEnum.SUCCESS.getRespMessage());
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSoundFloorByPageNo"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u58f0\u97f3\u5206\u5c42\u6620\u5c04", httpMethod="POST", consumes="application/json")
    public HttpBaseResponse getSoundFloorMap(@RequestBody RequestPage<ClientRequestParam> requestParam, HttpBaseResponse response) {
        log.info("json@getSoundFloorMap = [{}]", requestParam.getCondition());
        Page page = this.soundFloorService.querySoundFloorMap(requestParam);
        if (ObjectUtil.isNull((Object)page)) {
            response.setRespCode("100");
            response.setRespMessage("\u64cd\u4f5c\u901a\u7528\u5931\u8d25");
            return response;
        }
        response.setRespCode("000");
        response.setRespMessage("\u64cd\u4f5c\u6210\u529f");
        response.setData((Object)page);
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/getSoundFloorDataTotal"}, produces={"application/json;charset=UTF-8"})
    public String getDataTotal(@RequestBody SoundFloorRequest soundFloorRequest) {
        int total = 0;
        try {
            total = this.soundFloorService.querySoundFloorDataTotal(soundFloorRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Integer.toString(total);
    }

    @HeadTokenVerification
    @PostMapping(value={"/exportSoundMap"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u6240\u6709\u58f0\u97f3\u5206\u5c42\u6570\u636e", httpMethod="POST", consumes="application/json")
    public List getAllSoundFloorMap() {
        List itemList = this.soundFloorService.exportAllData();
        return itemList;
    }

    @HeadTokenVerification
    @PostMapping(value={"/delSoundFloorMap"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u58f0\u97f3\u5206\u5c42\u6570\u636e", httpMethod="POST", consumes="application/json")
    public String delMacMapping(@RequestParam long id) {
        log.info("\u5220\u9664\u7684\u683c\u53e3\u6620\u5c04\u5bf9\u8c61id\u4e3a\uff1a[{}]", (Object)id);
        boolean ok = this.soundFloorService.delSoundFloorMap(id);
        return ok ? "success" : "failure";
    }

    @HeadTokenVerification
    @PostMapping(value={"/delBatchSoundFloorMapping/{ids}"}, produces={"application/json"})
    public String delBatchSoundFloorMapping(@PathVariable String ids) {
        log.info("Batch delete ids [{}] ", (Object)ids);
        boolean ok = this.soundFloorService.batchDeleteSoundFloor(ids);
        return ok ? "success" : "failure";
    }

    @HeadTokenVerification
    @PostMapping(value={"/importSoundFloorMapping"}, produces={"application/json"})
    public HttpBaseResponse importSoundFloorMapping(@RequestBody List<SoundFloorRequest> soundFloorRequest) {
        log.info("\u5bfc\u5165\u58f0\u97f3\u5206\u5c42\u6570\u636e {}", (Object)JSONObject.toJSONString(soundFloorRequest));
        HttpBaseResponse response = new HttpBaseResponse();
        BaseResp baseResp = this.soundFloorService.checkExcelData(soundFloorRequest);
        if (!"000".equals(baseResp.getCode())) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage(baseResp.getMsg());
            return response;
        }
        boolean ok = this.soundFloorService.insertSoundFloorExportData(soundFloorRequest);
        if (!ok) {
            response.setRespCode(ResponseTypeEnum.GENERAL_FAIL.getRespCode());
            response.setRespMessage("\u4fdd\u5b58\u6570\u636e\u5931\u8d25");
            return response;
        }
        response.setRespCode(ResponseTypeEnum.SUCCESS.getRespCode());
        response.setRespMessage("\u5bfc\u5165\u6210\u529f");
        return response;
    }

    @HeadTokenVerification
    @PostMapping(value={"/updateSoundFloorMap"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u58f0\u97f3\u5206\u5c42\u4fe1\u606f", httpMethod="POST", consumes="application/json")
    public String updateSoundFloorMap(@RequestBody SoundFloorRequest soundFloorRequest) {
        soundFloorRequest.setModifyTime(new Date());
        boolean ok = this.soundFloorService.updateSoundFloorMap(soundFloorRequest);
        return ok ? "success" : "failure";
    }
}

