/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.system;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.controller.system.SystemManager;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.adapter.utils.SignUtil;
import com.yto.monitor.adapter.utils.UpgradeUtils;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.AppUpdateEntity;
import com.yto.monitor.common.entity.response.AppUpgradeInfo;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.AlibabaJsonUtil;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/Yto_Server/"})
public class SystemManagerController {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Value(value="${server.port}")
    private String serverPort;
    @Autowired
    private IAppInfoService appInfoService;
    @Autowired
    private UpgradeUtils upgradeUtils;
    private final AtomicBoolean upgradeLock = new AtomicBoolean(false);

    @PostMapping(value={"getSystemPId"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u7684PID", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse getSystemPId() {
        ClientHttpResponse response = new ClientHttpResponse();
        logger.info("\u6536\u5230\u83b7\u53d6\u7cfb\u7edf\u7684PID\u8bf7\u6c42\u3002");
        response.setData((Object)ExpUtils.PID);
        logger.info("\u54cd\u5e94\u6536\u5230\u83b7\u53d6\u7cfb\u7edf\u7684PID\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"getAppVersion"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<String> getAppVersion(@RequestParam(value="needLog", required=false, defaultValue="true") boolean needLog) {
        ClientHttpResponse response = new ClientHttpResponse();
        if (needLog) {
            logger.info("\u6536\u5230\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u8bf7\u6c42\u3002");
        }
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        res.put("fastdfs", true);
        res.put("gatewayPath", "");
        File file = new File(FileUtil.getAppDir());
        if (file.exists() && file.isDirectory()) {
            res.put("gatewayPath", file.getName());
            Date fileCreationTime = FileUtil.getFileCreationTime((File)file);
            res.put("dirCreationTime", fileCreationTime);
        }
        try {
            res.put("version", this.appInfoService.getMonitorSysVersion());
        }
        catch (Exception e) {
            if (needLog) {
                logger.error("\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u5f02\u5e38", (Throwable)e);
            }
            res.put("version", "");
        }
        response.setData((Object)JSONObject.toJSONString(res));
        if (needLog) {
            logger.info("\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u54cd\u5e94:" + GoogleJsonUtil.toJson((Object)response));
        }
        return response;
    }

    @PostMapping(value={"checkIsNewVersion"}, produces={"application/json"})
    @ApiOperation(value="\u6821\u9a8c\u662f\u5426\u662f\u65b0\u7248\u672c", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse checkIsNewVersion() {
        ClientHttpResponse response = new ClientHttpResponse();
        logger.info("\u6821\u9a8c\u662f\u5426\u662f\u65b0\u7248\u672c\u8bf7\u6c42\u3002");
        try {
            response.setData((Object)this.appInfoService.getMonitorSysVersion());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u5f02\u5e38", (Throwable)e);
            response.setData((Object)"");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"updateApp"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u66f4\u65b0", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<String> updateApp(@RequestParam(value="file") MultipartFile file, @RequestParam(value="version") String version) {
        logger.info("\u6536\u5230\u5e94\u7528\u66f4\u65b0\u8bf7\u6c42(\u8001\u63a5\u53e3)\uff0c\u65b0\u7248\u672c\u53f7\uff1a{}", (Object)version);
        ClientHttpResponse response = new ClientHttpResponse();
        String oldVersion = this.appInfoService.getMonitorSysVersion();
        if (version.equals(oldVersion)) {
            logger.error("\u5df2\u4e3a\u6700\u65b0\u7248\u672c\uff1a{}", (Object)version);
            response.setRespcode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u8be5\u76d1\u63a7\u7f51\u5173\u5df2\u4e3a\u6700\u65b0\u7248\uff1a" + version + ",\u8bf7\u5237\u65b0\u9875\u9762\u66f4\u65b0\u7248\u672c\u53f7");
            return response;
        }
        String targetDir = UpgradeUtils.createUnzipDir((String)version, (String)oldVersion);
        if (new File(targetDir).exists()) {
            logger.error("\u65b0\u7f51\u5173\u76ee\u5f55\u5df2\u5b58\u5728\uff1a{}", (Object)targetDir);
            response.setRespcode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u65b0\u7248\u672c\uff1a" + version + "\u7684\u76d1\u63a7\u7f51\u5173\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u8bf7\u6253\u5f00\u6587\u4ef6\u76ee\u5f55\u542f\u52a8\u65b0\u7248\u672c");
            return response;
        }
        if (!this.upgradeLock.compareAndSet(false, true)) {
            logger.error("\u672c\u6b21\u4e3a\u91cd\u590d\u5347\u7ea7(\u5347\u7ea7\u5904\u7406\u4e2d)");
            response.setRespcode(ResponseTypeEnum.HIGH_FREQUENCY.getRespCode());
            response.setRespMessage("\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5347\u7ea7");
            return response;
        }
        try {
            File newAppFile = UpgradeUtils.saveAppFileToLocalDisk((MultipartFile)file);
            if (newAppFile == null) {
                logger.error("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25");
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            File newFile = UpgradeUtils.unZipAppFile((File)newAppFile, (String)targetDir);
            if (newFile == null) {
                logger.error("\u89e3\u538b\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage("\u5b89\u88c5\u5305\u89e3\u6790\u5931\u8d25");
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            boolean b = this.upgradeUtils.modifySettingFiles(newFile);
            if (!b) {
                logger.error("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\u3002");
                response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                response.setRespMessage("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            response.setData((Object)newFile.getPath());
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        finally {
            this.upgradeLock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"updateAppNew"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u66f4\u65b0\u65b0\u63a5\u53e3", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<String> updateAppNew(@RequestParam(value="filePath") String filePath) {
        logger.info("\u6536\u5230\u5e94\u7528\u66f4\u65b0\u8bf7\u6c42\uff1a" + filePath);
        ClientHttpResponse response = new ClientHttpResponse();
        AppUpgradeInfo upgradeInfo = (AppUpgradeInfo)AlibabaJsonUtil.toBean((String)filePath, AppUpgradeInfo.class);
        if (StringUtils.isBlank((CharSequence)upgradeInfo.getVersion())) {
            logger.error("\u65b0\u7248\u672c\u53f7\u4e3a\u7a7a");
            response.setRespcode(ResponseTypeEnum.MISS_DATA_FAIL.getRespCode());
            response.setRespMessage("\u65b0\u7248\u672c\u53f7\u4e3a\u7a7a");
            return response;
        }
        String oldVersion = this.appInfoService.getMonitorSysVersion();
        if (upgradeInfo.getVersion().equals(oldVersion)) {
            logger.error("\u5df2\u4e3a\u6700\u65b0\u7248\u672c\uff1a{}", (Object)upgradeInfo.getVersion());
            response.setRespcode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u8be5\u76d1\u63a7\u7f51\u5173\u5df2\u4e3a\u6700\u65b0\u7248\uff1a" + upgradeInfo.getVersion() + ",\u8bf7\u5237\u65b0\u9875\u9762\u66f4\u65b0\u7248\u672c\u53f7");
            return response;
        }
        String targetDir = UpgradeUtils.createUnzipDir((String)upgradeInfo.getVersion(), (String)oldVersion);
        if (new File(targetDir).exists()) {
            logger.error("\u65b0\u7f51\u5173\u76ee\u5f55\u5df2\u5b58\u5728\uff1a{}", (Object)targetDir);
            response.setRespcode(ResponseTypeEnum.DATA_REPEAT.getRespCode());
            response.setRespMessage("\u65b0\u7248\u672c\uff1a" + upgradeInfo.getVersion() + "\u7684\u76d1\u63a7\u7f51\u5173\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u8bf7\u6253\u5f00\u6587\u4ef6\u76ee\u5f55\u542f\u52a8\u65b0\u7248\u672c");
            return response;
        }
        if (!this.upgradeLock.compareAndSet(false, true)) {
            logger.error("\u672c\u6b21\u4e3a\u91cd\u590d\u5347\u7ea7(\u5347\u7ea7\u5904\u7406\u4e2d)");
            response.setRespcode(ResponseTypeEnum.HIGH_FREQUENCY.getRespCode());
            response.setRespMessage("\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5347\u7ea7");
            return response;
        }
        try {
            File newAppFile = null;
            ClientHttpResponse clientHttpResponse = SystemManagerController.class;
            synchronized (SystemManagerController.class) {
                ClientHttpResponse clientHttpResponse2;
                newAppFile = UpgradeUtils.getNewAppFromLocal((String)upgradeInfo.getVersion());
                boolean isExist2 = newAppFile.exists() && newAppFile.isFile();
                logger.info(isExist2 ? "\u4e34\u65f6\u76ee\u5f55\u5b58\u5728\u65b0\u5305" : "\u4e34\u65f6\u76ee\u5f55\u4e0d\u5b58\u5728\u65b0\u5305");
                if (!isExist2) {
                    if (upgradeInfo.getExtend1() == 1) {
                        HashMap result = new HashMap(5);
                        AppUpdateEntity param = new AppUpdateEntity();
                        param.setAppVersion(upgradeInfo.getVersion());
                        param.setAppName(upgradeInfo.getAppFileName());
                        this.appInfoService.downloadAppNewWay(result, param);
                        newAppFile = UpgradeUtils.saveAppFileToTemp((byte[])((byte[])result.get("appBinary")), (String)String.valueOf(result.get("appFileName")));
                    } else {
                        newAppFile = UpgradeUtils.saveAppFileToTemp((byte[])UpgradeUtils.getResource((String)upgradeInfo.getAppUrl(), (String)upgradeInfo.getBase64UserMsg()), (String)upgradeInfo.getAppFileName());
                    }
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                if (newAppFile == null) {
                    logger.error("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25");
                    clientHttpResponse = response;
                    return clientHttpResponse;
                }
                File newFile = UpgradeUtils.unZipAppFile((File)newAppFile, (String)targetDir);
                if (newFile == null) {
                    logger.error("\u89e3\u538b\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u5b89\u88c5\u5305\u89e3\u6790\u5931\u8d25");
                    ClientHttpResponse isExist2 = response;
                    return isExist2;
                }
                boolean b = this.upgradeUtils.modifySettingFiles(newFile);
                if (!b) {
                    logger.error("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                    clientHttpResponse2 = response;
                    return clientHttpResponse2;
                }
                response.setData((Object)newFile.getPath());
                clientHttpResponse2 = response;
                return clientHttpResponse2;
            }
        }
        finally {
            this.upgradeLock.set(false);
        }
    }

    @PostMapping(value={"restartApp"}, produces={"application/json"})
    @ApiOperation(value="\u91cd\u542f\u5e94\u7528", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse restartApp(@RequestParam(value="newAppFolder", required=false) String newAppFolder) {
        File restartBatPath;
        logger.info("\u6536\u5230\u91cd\u542f\u5e94\u7528\u8bf7\u6c42:" + newAppFolder);
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((CharSequence)newAppFolder)) {
            newAppFolder = FileUtil.getAppDir();
        }
        if ((restartBatPath = new File(newAppFolder + File.separator + UpgradeUtils.getRestartScriptName())).exists() && restartBatPath.isFile()) {
            SystemManager.threadPool.submit((Runnable)new SystemManager.RestartSystemThread(newAppFolder, this.serverPort));
        } else {
            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
            response.setRespMessage("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
            logger.error("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8def\u5f84\uff1a" + newAppFolder);
        }
        logger.info("\u54cd\u5e94\u91cd\u542f\u5e94\u7528\u8bf7\u6c42\uff0c\u7ed3\u679c" + GoogleJsonUtil.toJson((Object)response));
        return response;
    }

    @PostMapping(value={"manageWebHeader"}, produces={"application/json"})
    public HttpBaseResponse<HashMap<String, String>> manageWebHeader() {
        return HttpBaseResponse.ok((Object)SignUtil.getHeader());
    }
}

