/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.controller.wcsMointor;

import com.yto.monitor.adapter.service.wcsMonitor.WcsMonitorMessageService;
import com.yto.monitor.adapter.utils.SpringBeanUtil;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/Yto_MonitorGateway/wcsClient/ws/{deviceId}")
public class WcsMonitorWebSocketServer {
    private WcsMonitorMessageService monitorMessageService;

    @OnOpen
    public void onOpen(@PathParam(value="deviceId") String deviceId, Session session) {
        this.getMonitorMessageService().addClient(deviceId, session);
    }

    @OnMessage
    public void onMessage(Session session, String msg) {
        this.getMonitorMessageService().onClientMessage(session, msg);
    }

    @OnClose
    public void onClose(Session session) {
        this.getMonitorMessageService().removeClient(session);
    }

    public WcsMonitorMessageService getMonitorMessageService() {
        if (this.monitorMessageService == null) {
            this.monitorMessageService = (WcsMonitorMessageService)SpringBeanUtil.getBean(WcsMonitorMessageService.class);
        }
        return this.monitorMessageService;
    }

    @OnError
    public void onError(Session session, Throwable error) {
    }
}

