/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.entity;

import com.yto.monitor.common.constant.DeviceTypeEnum;
import com.yto.monitor.common.util.ExpUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel
public class ExpWayBillCheckItem
implements Serializable {
    private static final long serialVersionUID = 1530556057906656067L;
    public static final String EXTEND3_SEPARATOR = "###";
    public static final int LENGTH = 85;
    @ApiParam(value="id")
    private String id;
    @ApiParam(value="key")
    private String itemKey;
    @ApiParam(value="\u521b\u5efa\u65f6\u95f4")
    private Date createDate;
    @ApiParam(value="\u4fee\u6539\u65f6\u95f4")
    private Date updateDate;
    @ApiParam(value="\u64cd\u4f5c\u65f6\u95f4")
    private String optTime;
    @ApiParam(value="\u64cd\u4f5c\u53f0mac/PDA/wcs:port")
    private String compMac;
    @ApiParam(value="'\u64cd\u4f5c\u53f0IP'")
    private String compIP;
    @ApiParam(value="\u8bbe\u5907\u7c7b\u578b:1-\u5feb\u624b\uff0c2-DWS\uff0c3-\u72c2\u626b\uff0c4-\u4eba\u5de5\u626b\u63cf\uff0c5-\u5feb\u624b+\u6446\u81c2\uff0c6-\u5feb\u624b+\u4ea4\u53c9\u5e26\uff0c7-DWS+\u6446\u81c2\uff0c8-DWS+\u4ea4\u53c9\u5e26\uff0c9-PDA 10-\u4ea4\u53c9\u5e26 11-\u5927\u4ef6\u5feb\u624b 13-\u672b\u7aef\u6446\u81c2 14-\u5927\u4ef6\u5feb\u624b+\u8ba1\u6ce1\u4eea")
    private String devType;
    @ApiParam(value="'\u5bb9\u5668\u53f7")
    private String containerNo;
    @ApiParam(value="'\u5355\u53f7")
    private String waybillNo;
    @ApiParam(value="\u64cd\u4f5c\u7801")
    private Integer opCode;
    @ApiParam(value="\u5ba2\u6237\u7aef\u767b\u5f55\u7528\u6237ID")
    private String userCode;
    @ApiParam(value="\u5ba2\u6237\u7aef\u767b\u5f55\u7528\u6237\u59d3\u540d")
    private String userName;
    @ApiParam(value="\u5f53\u524d\u64cd\u4f5c\u7f51\u70b9\u4ee3\u7801")
    private String orgCode;
    @ApiParam(value="\u5f53\u524d\u64cd\u4f5c\u7f51\u70b9\u540d\u79f0")
    private String orgName;
    @ApiParam(value="\u4e0a\u4e00\u7f51\u70b9")
    private String prevOrgCode;
    @ApiParam(value="\u4e0b\u4e00\u7f51\u70b9")
    private String nextOrgCode;
    @ApiParam(value="\u76ee\u7684\u5730\u7f51\u70b9")
    private String destOrgCode;
    @ApiParam(value="\u59cb\u53d1\u5730\u7f51\u70b9")
    private String sourceOrgCode;
    @ApiParam(value="\u6536\u53d1\u7c7b\u578b, 01:\u6b63\u5e38 02\uff1a\u9000\u56de\u4e00\u6b21 03\uff1a\u9000\u56de\u4e8c\u6b21 04\uff1a\u6ede\u7559\u4e00\u6b21 05\uff1a\u9519\u53d1\u8f6c\u53d1\u4e00\u6b21 06\uff1a\u9519\u53d1\u8f6c\u53d1\u4e8c\u6b21 07\u6ede\u7559\u4e8c\u6b21")
    private String ioType;
    @ApiParam(value="\u5b9e\u7269\u7c7b\u578b, 10:\u8fd0\u5355 20:\u5305\u7b7e 30:\u7b3c\u7b7e 40:\u8f66\u7b7e")
    private Integer expType;
    @ApiParam(value="\u64cd\u4f5c\u533a\u57df\u7801")
    private String optArea;
    @ApiParam(value="\u683c\u53e3\u53f7")
    private String latticeNo;
    @ApiParam(value="\u65f6\u6548\u4ee3\u7801")
    private String effectiveTypeCode;
    @ApiParam(value="\u4f53\u79ef\u957f\u5bbd\u9ad8 50,60,70")
    private String volume;
    @ApiParam(value="\u79f0\u5165\u91cd(kg)")
    private String weighWeight;
    @ApiParam(value="\u8f93\u5165\u91cd(kg)")
    private String inputWeight;
    @ApiParam(value="\u9884\u7559\u5b57\u6bb51")
    private String extend1;
    @ApiParam(value="\u9884\u7559\u5b57\u6bb52")
    private String extend2;
    @ApiParam(value="\u9884\u7559\u5b57\u6bb53")
    private String extend3;
    @ApiParam(value="\u9884\u7559\u5b57\u6bb55")
    private String extend5;
    @ApiParam(value="\u4e0a\u4f20\u72b6\u6001 0\u672a\u4e0a\u4f20 1\u4e0a\u4f20\u6210\u529f 2\u4e0a\u4f20\u5931\u8d25")
    private Integer uploadStatus;
    @ApiParam(value="\u4e0a\u4f20\u7ed3\u679c\u65e5\u5fd7")
    private String uploadMessage;

    public String getLatticeOrgCode(String prevOrgCode) {
        if (ExpUtils.isBlank((String)prevOrgCode) || !prevOrgCode.contains(";")) {
            return null;
        }
        return prevOrgCode.split(";")[0];
    }

    public String getDaTouBi(String prevOrgCode) {
        if (ExpUtils.isBlank((String)prevOrgCode) || !prevOrgCode.contains(";")) {
            return null;
        }
        String[] splitStr = prevOrgCode.split(";");
        if (splitStr.length >= 2) {
            return prevOrgCode.split(";")[1];
        }
        return null;
    }

    public String getLatticeThreeCode(String prevOrgCode) {
        if (ExpUtils.isBlank((String)prevOrgCode) || !prevOrgCode.contains(";")) {
            return null;
        }
        String[] splitStr = prevOrgCode.split(";");
        if (splitStr.length >= 3) {
            return prevOrgCode.split(";")[2];
        }
        return null;
    }

    public String getLatticeOrgName(String prevOrgCode) {
        String[] splitStr;
        if (ExpUtils.isBlank((String)prevOrgCode) || !prevOrgCode.contains(";")) {
            return null;
        }
        if (prevOrgCode.length() >= 85 && ExpUtils.isNotBlank((String)this.extend3) && this.extend3.contains(EXTEND3_SEPARATOR)) {
            prevOrgCode = prevOrgCode + this.extend3.split(EXTEND3_SEPARATOR)[1];
        }
        if ((splitStr = prevOrgCode.split(";")).length >= 4) {
            return prevOrgCode.split(";")[3];
        }
        return null;
    }

    public String getDaTouBiFromExtend3(String extend3) {
        if (ExpUtils.isBlank((String)extend3)) {
            return null;
        }
        if (extend3.contains(EXTEND3_SEPARATOR)) {
            return extend3.split(EXTEND3_SEPARATOR)[0];
        }
        return extend3;
    }

    public String getNameByDeviceType(String devType) {
        if (ExpUtils.isBlank((String)devType)) {
            return "";
        }
        int deviceType = Integer.valueOf(devType);
        if (deviceType == DeviceTypeEnum.DWS.getIndex() || deviceType == DeviceTypeEnum.SWING_ARM_DWS.getIndex() || deviceType == DeviceTypeEnum.FAST_HAND.getIndex() || deviceType == DeviceTypeEnum.SWING_ARM_FAST_HAND.getIndex()) {
            return "\u64cd\u4f5c\u53f0";
        }
        if (deviceType == DeviceTypeEnum.CROSS_BELT_DWS.getIndex() || deviceType == DeviceTypeEnum.CROSS_BELT_FAST_HAND.getIndex()) {
            return "\u4f9b\u4ef6\u53f0";
        }
        if (deviceType == DeviceTypeEnum.CRAZY_SCAN.getIndex()) {
            return "\u626b\u63cf\u4eea";
        }
        if (deviceType == DeviceTypeEnum.MANUAL_SCAN.getIndex()) {
            return "\u5df4\u67aa";
        }
        if (deviceType == DeviceTypeEnum.PDA.getIndex()) {
            return "PDA";
        }
        if (deviceType == DeviceTypeEnum.CROSS_BELT.getIndex()) {
            return "\u4ea4\u53c9\u5e26";
        }
        if (deviceType == DeviceTypeEnum.TERMINAL_SWING.getIndex() || deviceType == DeviceTypeEnum.DWS_ENDSWINGARM.getIndex() || deviceType == DeviceTypeEnum.SIXSIDESSCAN_ENDSWINGARM.getIndex()) {
            return "\u672b\u7aef\u6446\u81c2";
        }
        return "";
    }

    public boolean isAutoDevice(String deviceType) {
        if (ExpUtils.isBlank((String)deviceType)) {
            return false;
        }
        int devType = Integer.parseInt(deviceType);
        return DeviceTypeEnum.CROSS_BELT_FAST_HAND.getIndex() == devType || DeviceTypeEnum.CROSS_BELT.getIndex() == devType || DeviceTypeEnum.CROSS_BELT_DWS.getIndex() == devType || DeviceTypeEnum.SWING_ARM_FAST_HAND.getIndex() == devType || DeviceTypeEnum.SWING_ARM_DWS.getIndex() == devType || DeviceTypeEnum.TERMINAL_SWING.getIndex() == devType || DeviceTypeEnum.DWS_ENDSWINGARM.getIndex() == devType || DeviceTypeEnum.SIXSIDESSCAN_ENDSWINGARM.getIndex() == devType || DeviceTypeEnum.SIXSIDESSCAN_CROSSBELT.getIndex() == devType;
    }

    public boolean isSwingDevice(String deviceType) {
        if (ExpUtils.isBlank((String)deviceType)) {
            return false;
        }
        int devType = Integer.parseInt(deviceType);
        return DeviceTypeEnum.SWING_ARM_FAST_HAND.getIndex() == devType || DeviceTypeEnum.SWING_ARM_DWS.getIndex() == devType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpWayBillCheckItem that = (ExpWayBillCheckItem)o;
        return Objects.equals(this.optTime, that.optTime) && Objects.equals(this.waybillNo, that.waybillNo) && Objects.equals(this.opCode, that.opCode);
    }

    public int hashCode() {
        return Objects.hash(this.optTime, this.waybillNo, this.opCode);
    }

    public String getId() {
        return this.id;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public String getOptTime() {
        return this.optTime;
    }

    public String getCompMac() {
        return this.compMac;
    }

    public String getCompIP() {
        return this.compIP;
    }

    public String getDevType() {
        return this.devType;
    }

    public String getContainerNo() {
        return this.containerNo;
    }

    public String getWaybillNo() {
        return this.waybillNo;
    }

    public Integer getOpCode() {
        return this.opCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getPrevOrgCode() {
        return this.prevOrgCode;
    }

    public String getNextOrgCode() {
        return this.nextOrgCode;
    }

    public String getDestOrgCode() {
        return this.destOrgCode;
    }

    public String getSourceOrgCode() {
        return this.sourceOrgCode;
    }

    public String getIoType() {
        return this.ioType;
    }

    public Integer getExpType() {
        return this.expType;
    }

    public String getOptArea() {
        return this.optArea;
    }

    public String getLatticeNo() {
        return this.latticeNo;
    }

    public String getEffectiveTypeCode() {
        return this.effectiveTypeCode;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getWeighWeight() {
        return this.weighWeight;
    }

    public String getInputWeight() {
        return this.inputWeight;
    }

    public String getExtend1() {
        return this.extend1;
    }

    public String getExtend2() {
        return this.extend2;
    }

    public String getExtend3() {
        return this.extend3;
    }

    public String getExtend5() {
        return this.extend5;
    }

    public Integer getUploadStatus() {
        return this.uploadStatus;
    }

    public String getUploadMessage() {
        return this.uploadMessage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setOptTime(String optTime) {
        this.optTime = optTime;
    }

    public void setCompMac(String compMac) {
        this.compMac = compMac;
    }

    public void setCompIP(String compIP) {
        this.compIP = compIP;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public void setContainerNo(String containerNo) {
        this.containerNo = containerNo;
    }

    public void setWaybillNo(String waybillNo) {
        this.waybillNo = waybillNo;
    }

    public void setOpCode(Integer opCode) {
        this.opCode = opCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setPrevOrgCode(String prevOrgCode) {
        this.prevOrgCode = prevOrgCode;
    }

    public void setNextOrgCode(String nextOrgCode) {
        this.nextOrgCode = nextOrgCode;
    }

    public void setDestOrgCode(String destOrgCode) {
        this.destOrgCode = destOrgCode;
    }

    public void setSourceOrgCode(String sourceOrgCode) {
        this.sourceOrgCode = sourceOrgCode;
    }

    public void setIoType(String ioType) {
        this.ioType = ioType;
    }

    public void setExpType(Integer expType) {
        this.expType = expType;
    }

    public void setOptArea(String optArea) {
        this.optArea = optArea;
    }

    public void setLatticeNo(String latticeNo) {
        this.latticeNo = latticeNo;
    }

    public void setEffectiveTypeCode(String effectiveTypeCode) {
        this.effectiveTypeCode = effectiveTypeCode;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public void setWeighWeight(String weighWeight) {
        this.weighWeight = weighWeight;
    }

    public void setInputWeight(String inputWeight) {
        this.inputWeight = inputWeight;
    }

    public void setExtend1(String extend1) {
        this.extend1 = extend1;
    }

    public void setExtend2(String extend2) {
        this.extend2 = extend2;
    }

    public void setExtend3(String extend3) {
        this.extend3 = extend3;
    }

    public void setExtend5(String extend5) {
        this.extend5 = extend5;
    }

    public void setUploadStatus(Integer uploadStatus) {
        this.uploadStatus = uploadStatus;
    }

    public void setUploadMessage(String uploadMessage) {
        this.uploadMessage = uploadMessage;
    }

    public String toString() {
        return "ExpWayBillCheckItem(id=" + this.getId() + ", itemKey=" + this.getItemKey() + ", createDate=" + this.getCreateDate() + ", updateDate=" + this.getUpdateDate() + ", optTime=" + this.getOptTime() + ", compMac=" + this.getCompMac() + ", compIP=" + this.getCompIP() + ", devType=" + this.getDevType() + ", containerNo=" + this.getContainerNo() + ", waybillNo=" + this.getWaybillNo() + ", opCode=" + this.getOpCode() + ", userCode=" + this.getUserCode() + ", userName=" + this.getUserName() + ", orgCode=" + this.getOrgCode() + ", orgName=" + this.getOrgName() + ", prevOrgCode=" + this.getPrevOrgCode() + ", nextOrgCode=" + this.getNextOrgCode() + ", destOrgCode=" + this.getDestOrgCode() + ", sourceOrgCode=" + this.getSourceOrgCode() + ", ioType=" + this.getIoType() + ", expType=" + this.getExpType() + ", optArea=" + this.getOptArea() + ", latticeNo=" + this.getLatticeNo() + ", effectiveTypeCode=" + this.getEffectiveTypeCode() + ", volume=" + this.getVolume() + ", weighWeight=" + this.getWeighWeight() + ", inputWeight=" + this.getInputWeight() + ", extend1=" + this.getExtend1() + ", extend2=" + this.getExtend2() + ", extend3=" + this.getExtend3() + ", extend5=" + this.getExtend5() + ", uploadStatus=" + this.getUploadStatus() + ", uploadMessage=" + this.getUploadMessage() + ")";
    }
}

