/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.entity;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.yto.monitor.common.util.DateUtil;
import java.io.Serializable;
import java.util.Date;

public class OssClientHolder
implements Serializable {
    private String sessionName;
    private String endPoint;
    private String bucketName;
    private String accessKeyId;
    private String secretAccessKey;
    private String securityToken;
    private Date expirationTime;
    private Integer trafficLimit;
    private String optCallbackMuti;
    private String optCallback;
    private String oxmsCallBack;
    private OSS ossClient;

    public boolean isTokenOk() {
        return this.expirationTime != null && this.expirationTime.getTime() - System.currentTimeMillis() > 120000L && this.ossClient != null;
    }

    public void initOssClient() {
        this.ossClient = new OSSClientBuilder().build(this.endPoint, this.accessKeyId, this.secretAccessKey, this.securityToken);
    }

    public void clientShutdown() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = DateUtil.UTCParse((String)expirationTime, (String)"GMT+8");
    }

    public void setTrafficLimit(Integer trafficLimit) {
        this.trafficLimit = trafficLimit;
    }

    public void setOptCallbackMuti(String optCallbackMuti) {
        this.optCallbackMuti = optCallbackMuti;
    }

    public void setOptCallback(String optCallback) {
        this.optCallback = optCallback;
    }

    public void setOxmsCallBack(String oxmsCallBack) {
        this.oxmsCallBack = oxmsCallBack;
    }

    public void setOssClient(OSS ossClient) {
        this.ossClient = ossClient;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public Integer getTrafficLimit() {
        return this.trafficLimit;
    }

    public String getOptCallbackMuti() {
        return this.optCallbackMuti;
    }

    public String getOptCallback() {
        return this.optCallback;
    }

    public String getOxmsCallBack() {
        return this.oxmsCallBack;
    }

    public OSS getOssClient() {
        return this.ossClient;
    }
}

