/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.entity.configUpdate;

import com.yto.monitor.adapter.constant.ConfigTypeEnum;
import com.yto.monitor.adapter.constant.ScenarioEnum;
import com.yto.monitor.adapter.entity.configUpdate.BaseConfigRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

@ApiModel(value="\u4e1a\u52a1\u7f51\u5173\u914d\u7f6e\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\u5b9e\u4f53")
public class BusiConfigQueryRequest
extends BaseConfigRequest {
    @ApiModelProperty(value="\u914d\u7f6e\u7c7b\u578b")
    private String type;
    @ApiModelProperty(value="\u5e94\u7528\u4f7f\u7528\u573a\u666f")
    private List<String> scenarioList;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getScenarioList() {
        return this.scenarioList;
    }

    public void setScenarioList(List<String> scenarioList) {
        this.scenarioList = scenarioList;
    }

    public boolean checkParamOk() {
        return this.checkScenarioOk() && super.checkParamOk();
    }

    private boolean checkScenarioOk() {
        boolean configTypeOk = ConfigTypeEnum.validateOk((String)this.type);
        if (!configTypeOk) {
            return false;
        }
        if (ConfigTypeEnum.ALL.getType().equalsIgnoreCase(this.type)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.scenarioList)) {
            boolean notOk = this.scenarioList.stream().anyMatch(item -> !ScenarioEnum.validateOk((String)item));
            return !notOk;
        }
        return false;
    }

    public String toString() {
        return "BusiConfigQueryRequest{scenarioList=" + this.scenarioList + ", appName='" + this.appName + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }
}

