/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.entity.request;

import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.DeliveryWarehouse;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class ImportDeliveryWarehouseReq {
    private int rowNum;
    private String storeRoomNo;
    private String threeCode;
    private String createUserCode;
    private String createUserName;

    public DeliveryWarehouse toEntity() {
        DeliveryWarehouse entity = new DeliveryWarehouse();
        entity.setOrgCode(SysPropertiesConfig.getOrgCode());
        entity.setOrgName(SysPropertiesConfig.getOrgName());
        entity.setCreateTime(new Date());
        entity.setStoreRoomNo(Integer.valueOf(Integer.parseInt(this.storeRoomNo)));
        entity.setThreeCode(this.threeCode);
        entity.setCreateUserCode(this.createUserCode);
        entity.setCreateUserName(this.createUserName);
        entity.setSendStatus(Integer.valueOf(SendStatus.UNSENT.getStatus()));
        entity.setDeleted(Boolean.valueOf(false));
        return entity;
    }

    public String checkData() {
        String s;
        String checkThreeCodeMsg;
        StringBuilder stringBuilder = new StringBuilder();
        String checkStoreRoomNoMsg = this.checkStoreRoomNo();
        if (checkStoreRoomNoMsg != null) {
            stringBuilder.append(checkStoreRoomNoMsg).append(",");
        }
        if ((checkThreeCodeMsg = this.checkThreeCode()) != null) {
            stringBuilder.append(checkThreeCodeMsg).append(",");
        }
        return StringUtils.isBlank((String)(s = stringBuilder.toString())) ? null : s;
    }

    private String checkStoreRoomNo() {
        if (StringUtils.isBlank((String)this.storeRoomNo)) {
            return "\u5e93\u623f\u53f7\u4e3a\u7a7a";
        }
        try {
            int storeRoomNoInt = Integer.parseInt(this.storeRoomNo);
            if (storeRoomNoInt < 1 || storeRoomNoInt > 9) {
                return "\u5e93\u623f\u53f7\u8303\u56f4\u53ea\u80fd\u57281-9";
            }
        }
        catch (NumberFormatException e) {
            return "\u5e93\u623f\u53f7\u53ea\u80fd\u4e3a\u6570\u5b57";
        }
        return null;
    }

    private String checkThreeCode() {
        if (StringUtils.isBlank((String)this.threeCode)) {
            return "\u4e00\u6bb5\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.threeCode.length() != 3) {
            return "\u4e00\u6bb5\u7801\u53ea\u80fd\u4e3a3\u4f4d";
        }
        if (!StringUtils.isNumeric((String)this.threeCode)) {
            return "\u4e00\u6bb5\u7801\u53ea\u80fd\u4e3a\u7eaf\u6570\u5b57";
        }
        return null;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public String getStoreRoomNo() {
        return this.storeRoomNo;
    }

    public String getThreeCode() {
        return this.threeCode;
    }

    public String getCreateUserCode() {
        return this.createUserCode;
    }

    public String getCreateUserName() {
        return this.createUserName;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public void setStoreRoomNo(String storeRoomNo) {
        this.storeRoomNo = storeRoomNo;
    }

    public void setThreeCode(String threeCode) {
        this.threeCode = threeCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportDeliveryWarehouseReq)) {
            return false;
        }
        ImportDeliveryWarehouseReq other = (ImportDeliveryWarehouseReq)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getRowNum() != other.getRowNum()) {
            return false;
        }
        String this$storeRoomNo = this.getStoreRoomNo();
        String other$storeRoomNo = other.getStoreRoomNo();
        if (this$storeRoomNo == null ? other$storeRoomNo != null : !this$storeRoomNo.equals(other$storeRoomNo)) {
            return false;
        }
        String this$threeCode = this.getThreeCode();
        String other$threeCode = other.getThreeCode();
        if (this$threeCode == null ? other$threeCode != null : !this$threeCode.equals(other$threeCode)) {
            return false;
        }
        String this$createUserCode = this.getCreateUserCode();
        String other$createUserCode = other.getCreateUserCode();
        if (this$createUserCode == null ? other$createUserCode != null : !this$createUserCode.equals(other$createUserCode)) {
            return false;
        }
        String this$createUserName = this.getCreateUserName();
        String other$createUserName = other.getCreateUserName();
        return !(this$createUserName == null ? other$createUserName != null : !this$createUserName.equals(other$createUserName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportDeliveryWarehouseReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRowNum();
        String $storeRoomNo = this.getStoreRoomNo();
        result = result * 59 + ($storeRoomNo == null ? 43 : $storeRoomNo.hashCode());
        String $threeCode = this.getThreeCode();
        result = result * 59 + ($threeCode == null ? 43 : $threeCode.hashCode());
        String $createUserCode = this.getCreateUserCode();
        result = result * 59 + ($createUserCode == null ? 43 : $createUserCode.hashCode());
        String $createUserName = this.getCreateUserName();
        result = result * 59 + ($createUserName == null ? 43 : $createUserName.hashCode());
        return result;
    }

    public String toString() {
        return "ImportDeliveryWarehouseReq(rowNum=" + this.getRowNum() + ", storeRoomNo=" + this.getStoreRoomNo() + ", threeCode=" + this.getThreeCode() + ", createUserCode=" + this.getCreateUserCode() + ", createUserName=" + this.getCreateUserName() + ")";
    }
}

