/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.interceptor;

import cn.com.yto56.basic.framework.rest.version.ApiRequestMappingHandlerMapping;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.annotation.HeadTokenVerification;
import com.yto.monitor.adapter.service.security.SecurityService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.ResponseTypeEnum;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthorizeInterceptor
implements HandlerInterceptor {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final List<String> NON_REFRESHING_URLS = Arrays.asList("/Yto_MonitorGateway/mqtt/messageRemind/monitorMsgUnRead", "/Yto_MonitorServer/software/listAllAppInfo");
    @Autowired
    private SecurityService securityService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ApiRequestMappingHandlerMapping handlerMapping;
        Object defaultHandler;
        HandlerMethod handlerMethod = null;
        if (handler instanceof HandlerMethod) {
            handlerMethod = (HandlerMethod)handler;
        }
        if (handler instanceof ApiRequestMappingHandlerMapping && (defaultHandler = (handlerMapping = (ApiRequestMappingHandlerMapping)handler).getDefaultHandler()) instanceof HandlerMethod) {
            handlerMethod = (HandlerMethod)defaultHandler;
        }
        if (handlerMethod == null) {
            return true;
        }
        HeadTokenVerification headTokenVerification = (HeadTokenVerification)handlerMethod.getMethodAnnotation(HeadTokenVerification.class);
        if (headTokenVerification == null) {
            return true;
        }
        String token = request.getHeader("Authorization");
        String userCode = request.getHeader("UserCode");
        if (!this.securityService.verifyWebToken(userCode, token)) {
            logger.error("\u975e\u6cd5\u8bf7\u6c42 Authorization\uff1a{} UserCode\uff1a{} URL\uff1a{}", new Object[]{token, userCode, request.getRequestURI()});
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(HttpStatus.OK.value());
            HttpBaseResponse responseData = new HttpBaseResponse();
            responseData.setRespCode(ResponseTypeEnum.FORBIDDEN.getRespCode());
            responseData.setRespMessage("\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            response.getWriter().print(JSONObject.toJSONString((Object)responseData));
            return false;
        }
        if (!NON_REFRESHING_URLS.contains(request.getRequestURI())) {
            logger.info("URL:{} userCode:{}", (Object)request.getRequestURI(), (Object)userCode);
            this.securityService.refreshWebToken(token);
        }
        return true;
    }
}

