/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job;

import com.yto.monitor.adapter.schedule.BaseJob;
import com.yto.monitor.adapter.service.BackUpDataBaseManager;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class BackUpBaseInfoJob
extends BaseJob {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Value(value="${adapter.cron.backUpBaseInfoJob}")
    private String backUpBaseInfoJob;
    @Autowired
    private BackUpDataBaseManager backUpDataBaseManager;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSS");

    public String getCronExpression() {
        return this.backUpBaseInfoJob;
    }

    public void execute(JobExecutionContext context) {
        String format = dateFormat.format(System.currentTimeMillis());
        logger.info("\u7cfb\u7edf\u5b9a\u65f6\u5907\u4efdsql\u4e0a\u4f20\u5f00\u59cb,{}", (Object)format);
        String sqlPath = this.backUpDataBaseManager.exportSql();
        if (StringUtils.isBlank((CharSequence)sqlPath)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u5bfc\u51fasql\u5931\u8d25");
            return;
        }
        String errorMessage = this.backUpDataBaseManager.uploadSqlFile(sqlPath, "", "\u7cfb\u7edf\u5b9a\u65f6\u5907\u4efd\u4e0a\u4f20");
        logger.info("\u7cfb\u7edf\u5b9a\u65f6\u5907\u4efd\u4e0a\u4f20\u7ed3\u675f,{}", (Object)errorMessage);
    }
}

