/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job;

import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.UploadModeEnum;
import com.yto.monitor.adapter.schedule.BaseJob;
import com.yto.monitor.adapter.service.manageWebDownload.SubshortCodeChangeDownloadService;
import com.yto.monitor.adapter.service.manageWebDownload.ThreeCodeChangeDownloadService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DownloadDailyJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(DownloadDailyJob.class);
    public static final String CRON_DAY = "0 0 7 * * ?";
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private ThreeCodeChangeDownloadService threeCodeChangeDownloadService;
    @Autowired
    private SubshortCodeChangeDownloadService subshortCodeChangeDownloadService;

    public String getCronExpression() {
        String str1 = SysPropertiesConfig.getOrgCode().substring(0, 4);
        int int1 = Integer.valueOf(str1);
        int int2 = Integer.valueOf(SysPropertiesConfig.getOrgCode());
        int m = (int1 + int2) % 60;
        String cronExpression = CRON_DAY.replaceAll("0", m + "");
        logger.info("\u4e0b\u8f7dMySQL\u57fa\u7840\u6570\u636e(\u6309\u65e5\u66f4\u65b0)\u7684\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4f7f\u7528\u968f\u673a\u8ba1\u7b97\u540e\u4e3a:{}", (Object)cronExpression);
        return cronExpression;
    }

    public void execute(JobExecutionContext context) {
        this.run();
    }

    public void run() {
        if (UploadModeEnum.ALL.getMode() != this.commonConfig.getUploadModel()) {
            logger.info("\u5f53\u524d\u7f51\u5173\u6a21\u5f0f\uff1a{} \u4e0d\u6267\u884c\u6309\u5929\u4e0b\u8f7d\u6570\u636e", (Object)this.commonConfig.getUploadModel());
            return;
        }
        try {
            logger.info("\u5f00\u59cb\u6309\u5929\u4e0b\u8f7d\u6570\u636e...");
            this.threeCodeChangeDownloadService.sync();
            this.subshortCodeChangeDownloadService.sync();
            logger.info("\u7ed3\u675f\u6309\u5929\u4e0b\u8f7d\u6570\u636e...");
        }
        catch (Exception e) {
            logger.error("\u6309\u5929\u4e0b\u8f7d\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

