/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job;

import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.constant.UploadModeEnum;
import com.yto.monitor.adapter.schedule.BaseJob;
import com.yto.monitor.adapter.service.DeviceActiveService;
import com.yto.monitor.adapter.service.IOptShareConfigService;
import com.yto.monitor.adapter.service.SpecialOrgService;
import com.yto.monitor.adapter.service.UnloadWithDispatchExcludeService;
import com.yto.monitor.adapter.service.VersionService;
import com.yto.monitor.adapter.service.checkData.OnlineCheckDataService;
import com.yto.monitor.adapter.service.download.CountryStationService;
import com.yto.monitor.adapter.service.download.CustomerService;
import com.yto.monitor.adapter.service.download.DingTalkUserService;
import com.yto.monitor.adapter.service.download.EmployeeService;
import com.yto.monitor.adapter.service.download.EndCodeService;
import com.yto.monitor.adapter.service.download.LineSectionService;
import com.yto.monitor.adapter.service.download.OrgInfoService;
import com.yto.monitor.adapter.service.download.OrgPackageRuleV1Service;
import com.yto.monitor.adapter.service.download.OsdCameraBindingService;
import com.yto.monitor.adapter.service.download.OsdCameraService;
import com.yto.monitor.adapter.service.download.RouteOperationNodeService;
import com.yto.monitor.adapter.service.download.SupplierManageService;
import com.yto.monitor.adapter.service.download.WarehouseService;
import com.yto.monitor.adapter.service.login.LoginWhiteService;
import com.yto.monitor.common.entity.base.OrgInfoEntity;
import com.yto.monitor.common.entity.request.QueryJobCronReq;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DownloadHourJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(DownloadHourJob.class);
    public static final String CRON_DOWNLOAD_BASE_DATA = "0 30 0/1 * * ?";
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private OnlineCheckDataService onlineCheckDataService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private RouteOperationNodeService routeOperationNodeService;
    @Autowired
    private SupplierManageService supplierManageService;
    @Autowired
    private IOptShareConfigService optShareConfigService;
    @Autowired
    private EndCodeService endCodeService;
    @Autowired
    private CountryStationService countryStationService;
    @Autowired
    private LineSectionService lineSectionService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private OrgPackageRuleV1Service orgPackageRuleV1Service;
    @Autowired
    private SpecialOrgService specialOrgService;
    @Autowired
    private LoginWhiteService loginWhiteService;
    @Autowired
    private DeviceActiveService deviceActiveService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private WarehouseService warehouseService;
    @Autowired
    private OsdCameraBindingService osdCameraBindingService;
    @Autowired
    private UnloadWithDispatchExcludeService unloadWithDispatchExcludeService;
    @Autowired
    private OsdCameraService osdCameraService;
    @Autowired
    private DingTalkUserService dingTalkUserService;
    private static final String TYPECRON = "cron";

    public String getCronExpression() {
        String orgCode = SysPropertiesConfig.getOrgCode();
        QueryJobCronReq queryJobCronReq = new QueryJobCronReq();
        queryJobCronReq.setOrgCode(orgCode);
        queryJobCronReq.setTypeCron(TYPECRON);
        String cron = this.onlineCheckDataService.queryJobCron(queryJobCronReq);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cron)) {
            logger.info("\u4f7f\u7528\u67e5\u8be2\u5230\u7684cron:{}", (Object)cron);
            return cron;
        }
        int int1 = Integer.valueOf(orgCode);
        int m = int1 % 60;
        String cronExpression = CRON_DOWNLOAD_BASE_DATA.replaceAll("^(\\d+\\s+){2}", m + " " + m + " ");
        logger.info("\u4e0b\u8f7dMySQL\u57fa\u7840\u6570\u636e(\u6309\u5c0f\u65f6\u66f4\u65b0)\u7684\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e3a:{}", (Object)cronExpression);
        return cronExpression;
    }

    public void execute(JobExecutionContext context) {
        this.run(false);
    }

    public void run(boolean isFirst) {
        if (UploadModeEnum.ALL.getMode() != this.commonConfig.getUploadModel()) {
            logger.info("\u5f53\u524d\u7f51\u5173\u6a21\u5f0f\uff1a{} \u4e0d\u6267\u884c\u57fa\u7840\u6570\u636e\u4e0b\u8f7d", (Object)this.commonConfig.getUploadModel());
            return;
        }
        try {
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u57fa\u7840\u6570\u636e...");
            this.orgInfoService.sync();
            if (StringUtils.isBlank((String)SysPropertiesConfig.getOrgName()) && StringUtils.isNotBlank((String)SysPropertiesConfig.getOrgCode())) {
                OrgInfoEntity orgInfoEntity = this.orgInfoService.getOrgInfoByCode(SysPropertiesConfig.getOrgCode(), true);
                if (orgInfoEntity != null) {
                    SysPropertiesConfig.setOrgName((String)orgInfoEntity.getName());
                }
                SysPropertiesConfig.print();
            }
            this.optShareConfigService.downloadData();
            this.routeOperationNodeService.sync();
            this.supplierManageService.sync();
            this.versionService.downloadMiniVersion();
            this.specialOrgService.downloadSpecialOrg();
            this.loginWhiteService.downloadWhiteList();
            this.deviceActiveService.downloadDeviceActiveByOrgCode();
            this.employeeService.sync();
            this.dingTalkUserService.sync();
            this.customerService.sync();
            this.lineSectionService.sync();
            this.endCodeService.sync();
            this.warehouseService.sync();
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            int remainder = hour % 3;
            if (remainder == 0 || isFirst) {
                this.countryStationService.sync();
            }
            this.orgPackageRuleV1Service.sync();
            this.osdCameraBindingService.sync();
            this.osdCameraService.sync();
            logger.info("\u7ed3\u675f\u4e0b\u8f7d\u57fa\u7840\u6570\u636e...");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u57fa\u7840\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

