/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job;

import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.service.CacheService;
import com.yto.monitor.adapter.service.CfgService;
import com.yto.monitor.adapter.service.DeliveryWarehouseService;
import com.yto.monitor.adapter.service.ExceptionLogService;
import com.yto.monitor.adapter.service.GatewayControlService;
import com.yto.monitor.adapter.service.IAppInfoService;
import com.yto.monitor.adapter.service.ManageConfigService;
import com.yto.monitor.adapter.service.SchemePermissionAssignmentService;
import com.yto.monitor.adapter.service.SystemMonitorService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HourJob {
    private static final ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(2);
    private static final Logger sysLogger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private ExceptionLogService exceptionLogService;
    @Autowired
    private IAppInfoService iAppInfoService;
    @Autowired
    private GatewayControlService gatewayControlService;
    @Autowired
    private DeliveryWarehouseService deliveryWarehouseService;
    @Autowired
    private SysPropertiesConfig sysPropertiesConfig;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private SchemePermissionAssignmentService schemePermissionAssignmentService;
    @Autowired
    private SystemMonitorService systemMonitorService;
    @Autowired
    private CfgService cfgService;
    @Autowired
    private ManageConfigService manageConfigService;

    public void start() {
        this.hourTask();
        this.hour6Task();
        this.hour24Task();
    }

    private void hourTask() {
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                this.cacheService.refresh();
                this.sysPropertiesConfig.refreshOrgInfo();
                this.exceptionLogService.checkException("6", null);
                this.schemePermissionAssignmentService.downloadSchemePermission();
                this.iAppInfoService.gateWaySendServer();
                this.systemMonitorService.printSystemMonitorInfo();
                this.manageConfigService.refreshManageConfig();
                this.cfgService.refreshClientConfigParam();
            }
            catch (Exception e) {
                sysLogger.info("1\u5c0f\u65f6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    private void hour6Task() {
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                this.iAppInfoService.sendToServer();
            }
            catch (Exception e) {
                sysLogger.info("\u5b9a\u65f6\u540c\u6b65app\u7248\u672c\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
        }, 0L, 6L, TimeUnit.HOURS);
    }

    private void hour24Task() {
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                this.exceptionLogService.loadApolloExceptionValue();
                this.exceptionLogService.checkException("4", null);
                this.gatewayControlService.loadGatewayControlValue();
                this.deliveryWarehouseService.downloadDeliveryWarehouse();
            }
            catch (Exception e) {
                sysLogger.error(e.getMessage(), (Throwable)e);
            }
        }, 0L, 24L, TimeUnit.HOURS);
    }
}

