/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job;

import com.yto.monitor.adapter.service.DeviceLoginService;
import com.yto.monitor.adapter.service.ElectronicScreenService;
import com.yto.monitor.adapter.service.RutBranchMergeService;
import com.yto.monitor.adapter.service.download.ExpCarTruckService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MinuteJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinuteJob.class);
    private static final ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(2);
    @Autowired
    private DeviceLoginService deviceLoginService;
    @Autowired
    private ElectronicScreenService electronicScreenService;
    @Autowired
    private RutBranchMergeService rutBranchMergeService;
    @Autowired
    private ExpCarTruckService expCarTruckService;

    public void start() {
        this.minute5Task();
        this.minute10Task();
        this.minute30Task();
    }

    private void minute5Task() {
        scheduledThreadPool.scheduleAtFixedRate(() -> {
            try {
                LOGGER.info("\u63a8\u9001\u7535\u5b50\u5c4fJob\u5f00\u59cb");
                this.electronicScreenService.requestElectronicScreenData();
            }
            catch (Exception e) {
                LOGGER.info("\u63a8\u9001\u7535\u5b50\u5c4fJob\u5f02\u5e38", (Throwable)e);
            }
            try {
                LOGGER.info("\u5f00\u59cb\u4e0a\u4f20\u767b\u5f55\u5347\u7ea7\u6570\u636e\u3002\u3002\u3002\u3002");
                this.deviceLoginService.uploadData();
                LOGGER.info("\u7ed3\u675f\u4e0a\u4f20\u767b\u5f55\u5347\u7ea7\u6570\u636e");
            }
            catch (Exception e) {
                LOGGER.error("\u767b\u5f55\u5347\u7ea7\u6570\u636e\u4e0a\u4f20\u5931\u8d25{}\uff0c{}", (Object)e, (Object)e.getMessage());
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private void minute10Task() {
        scheduledThreadPool.scheduleAtFixedRate(() -> this.rutBranchMergeService.uploadData(), 0L, 10L, TimeUnit.MINUTES);
    }

    private void minute30Task() {
        scheduledThreadPool.scheduleAtFixedRate(() -> this.expCarTruckService.sync(), 0L, 30L, TimeUnit.MINUTES);
    }
}

