/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job.thread;

import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;

public class DeleteImageDirThread
implements Runnable {
    private static final Logger logger = CustomLoggerFactory.ImageLogger();
    private final int days;
    private final File[] dirs;

    public DeleteImageDirThread(int days, File ... dirs) {
        this.days = days;
        this.dirs = dirs;
    }

    @Override
    public void run() {
        if (this.days == 0 || this.dirs == null || this.dirs.length == 0) {
            return;
        }
        Date currentDate = new Date();
        for (File dir : this.dirs) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            try {
                logger.info("\u5f00\u59cb\u6e05\u7406\u56fe\u7247\u76ee\u5f55\uff1a{} \u6e05\u7406\u521b\u5efa\u8d85\u8fc7{}\u5929\u7684\u6587\u4ef6\u5939", (Object)dir.getAbsolutePath(), (Object)this.days);
                FileUtil.deleteExpiredDir((File)dir, (Date)currentDate, (long)this.days);
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u76ee\u5f55\u5f02\u5e38 {}", (Object)dir, (Object)e);
            }
        }
    }
}

