/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job.thread;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.config.UrlConfig;
import com.yto.monitor.adapter.constant.ImageTokenRespEnum;
import com.yto.monitor.adapter.entity.OssClientHolder;
import com.yto.monitor.adapter.entity.request.ImageInfoUploadRequestEntity;
import com.yto.monitor.adapter.entity.request.ImagePushToServerEntity;
import com.yto.monitor.adapter.entity.request.ImageTokenRequestEntity;
import com.yto.monitor.adapter.entity.request.OssTokenReq;
import com.yto.monitor.adapter.entity.response.ImageTokenResponse;
import com.yto.monitor.adapter.job.thread.NamedThreadFactory;
import com.yto.monitor.adapter.service.UploadService;
import com.yto.monitor.adapter.service.impl.ExpImageUploadInfoService;
import com.yto.monitor.adapter.service.observer.BizTypeEnum;
import com.yto.monitor.adapter.service.observer.MessageTypeEnum;
import com.yto.monitor.adapter.service.observer.SubjectObj;
import com.yto.monitor.adapter.service.security.SecurityService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.entity.response.newserver.domain.NewServerResp;
import com.yto.monitor.common.util.AESUtils;
import com.yto.monitor.common.util.DateUtil;
import com.yto.monitor.common.util.GoogleJsonUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TransferImageInfoManager
implements UploadService<ImagePushToServerEntity> {
    private static final Logger logger = CustomLoggerFactory.ImageLogger();
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private ExpImageUploadInfoService expImageUploadInfoService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SecurityService securityService;
    private volatile OssClientHolder clientHolder;
    private static final String SUCCESS = "success";
    private static final String callBackBody = "{\\\"bucket\\\":${bucket},\\\"object\\\":${object},\\\"mimeType\\\":${mimeType},\\\"size\\\":${size},\\\"etag\\\":${etag},\\\"waybillNo\\\":${x:waybillNo},\\\"opOrgCode\\\":${x:opOrgCode},\\\"opCode\\\":${x:opCode},\\\"snNumber\\\":${x:snNumber},\\\"imgSource\\\":${x:imgSource},\\\"operateTimeStamp\\\":${x:operateTimeStamp}}";
    private static final String multiWaybillNoCallBackBody = "{\\\"bucket\\\":${bucket},\\\"object\\\":${object},\\\"mimeType\\\":${mimeType},\\\"size\\\":${size},\\\"etag\\\":${etag},\\\"waybillNos\\\":${x:waybillNos},\\\"opOrgCode\\\":${x:opOrgCode},\\\"opCode\\\":${x:opCode},\\\"snNumber\\\":${x:snNumber},\\\"imgSource\\\":${x:imgSource},\\\"operateTimeStamp\\\":${x:operateTimeStamp}}";

    private byte[] getDecryptBytes(File imgFile, ImagePushToServerEntity imageInfo) throws Exception {
        byte[] decryptByte = null;
        if (StringUtils.isBlank((CharSequence)imageInfo.getExtend3())) {
            decryptByte = FileUtils.readFileToByteArray((File)imgFile);
        } else if ("1".equals(imageInfo.getExtend3())) {
            decryptByte = AESUtils.decrypt((byte[])FileUtils.readFileToByteArray((File)imgFile), (String)AESUtils.getSecretKey((String)imageInfo.getExpressNumber()));
        } else if ("2".equals(imageInfo.getExtend3())) {
            byte[] fileBytes = FileUtils.readFileToByteArray((File)imgFile);
            byte[] prefixBytes = Arrays.copyOf(fileBytes, 1024);
            byte[] decryptPrefixBytes = AESUtils.decryptWithIv((byte[])prefixBytes, (String)imageInfo.getExpressNumber(), (String)imageInfo.getExpressNumber(), (int)16);
            decryptByte = AESUtils.replaceBytes((byte[])fileBytes, (byte[])decryptPrefixBytes);
        }
        return decryptByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendToServer(List<ImagePushToServerEntity> list) {
        for (ImagePushToServerEntity imageInfo : list) {
            PutObjectResult putObjectResult = null;
            try {
                boolean isUseful;
                File imgFile = new File(imageInfo.getImageLocation());
                if (!imgFile.exists() || !imgFile.isFile()) {
                    logger.error("\u627e\u4e0d\u5230\u56fe\u7247:{} {}", (Object)imageInfo.getExpressNumber(), (Object)imageInfo.getImageLocation());
                    imageInfo.setStatus(3);
                    imageInfo.setMessage("\u672c\u5730\u56fe\u7247\u4e0d\u5b58\u5728");
                    this.doUploadFailData(imageInfo);
                    continue;
                }
                if (!(this.clientHolder != null && this.clientHolder.isTokenOk() || (isUseful = this.getTokenFromRemote()))) {
                    this.handleFailUpload(imageInfo);
                    continue;
                }
                byte[] decryptBytes = this.getDecryptBytes(imgFile, imageInfo);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(decryptBytes);
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.clientHolder.getBucketName(), imgFile.getName().split("\\.")[0], (InputStream)inputStream);
                Callback callback = this.buildCallbackParam(imageInfo);
                putObjectRequest.setCallback(callback);
                long start = System.currentTimeMillis();
                putObjectResult = this.clientHolder.getOssClient().putObject(putObjectRequest);
                byte[] buf = new byte[1024];
                StringBuffer uploadResult = new StringBuffer();
                int len = -1;
                while ((len = putObjectResult.getResponse().getContent().read(buf)) != -1) {
                    uploadResult.append(new String(buf, 0, len, this.commonConfig.getImageUploadCharset()));
                }
                String size = String.format("%.3f", (double)imgFile.length() / 1024.0);
                if (uploadResult.toString().contains("success")) {
                    logger.info("\u4e0a\u4f20\u6210\u529f:{} size:{} \u8017\u65f6:{}", new Object[]{imageInfo.getImageLocation(), size, System.currentTimeMillis() - start});
                    this.handleSuccessUpload(imageInfo);
                    continue;
                }
                logger.error("\u4e0a\u4f20\u5931\u8d25:{} size:{} \u54cd\u5e94\u4e3a:{}", new Object[]{imageInfo, size, uploadResult});
                this.handleFailUpload(imageInfo);
            }
            catch (OSSException oe) {
                logger.error("\u4e0a\u4f20OSS\u65f6\u51fa\u9519\uff1a{}", (Object)imageInfo, (Object)oe);
                this.handleFailUpload(imageInfo);
            }
            catch (ClientException ce) {
                logger.error("\u4e0a\u4f20\u65f6\u65e0\u6cd5\u8fde\u63a5\u5230Server\uff1a{}", (Object)imageInfo, (Object)ce);
                this.handleFailUpload(imageInfo);
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6\u4e0a\u4f20\u56fe\u7247\u54cd\u5e94\u6d41\u65f6\u51fa\u9519\uff1a{}", (Object)imageInfo, (Object)e);
                this.handleFailUpload(imageInfo);
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u51fa\u9519\uff1a{}", (Object)imageInfo, (Object)e);
                this.handleFailUpload(imageInfo);
            }
            finally {
                try {
                    if (putObjectResult == null || putObjectResult.getResponse().getContent() == null) continue;
                    putObjectResult.getResponse().getContent().close();
                }
                catch (Exception e) {
                    logger.error("\u4e0a\u4f20\u56fe\u7247\u7684\u8bfb\u53d6\u6d41\u65e0\u6cd5\u5173\u95ed", (Throwable)e);
                }
            }
        }
        return 0;
    }

    private Callback buildCallbackParam(ImagePushToServerEntity imageInfo) {
        boolean multi = this.isMultiWaybillNo(imageInfo.getExpressNumber());
        Callback callback = new Callback();
        callback.setCallbackUrl(multi ? this.clientHolder.getOptCallbackMuti() : this.clientHolder.getOptCallback());
        callback.setCallbackBody(multi ? "{\\\"bucket\\\":${bucket},\\\"object\\\":${object},\\\"mimeType\\\":${mimeType},\\\"size\\\":${size},\\\"etag\\\":${etag},\\\"waybillNos\\\":${x:waybillNos},\\\"opOrgCode\\\":${x:opOrgCode},\\\"opCode\\\":${x:opCode},\\\"snNumber\\\":${x:snNumber},\\\"imgSource\\\":${x:imgSource},\\\"operateTimeStamp\\\":${x:operateTimeStamp}}" : "{\\\"bucket\\\":${bucket},\\\"object\\\":${object},\\\"mimeType\\\":${mimeType},\\\"size\\\":${size},\\\"etag\\\":${etag},\\\"waybillNo\\\":${x:waybillNo},\\\"opOrgCode\\\":${x:opOrgCode},\\\"opCode\\\":${x:opCode},\\\"snNumber\\\":${x:snNumber},\\\"imgSource\\\":${x:imgSource},\\\"operateTimeStamp\\\":${x:operateTimeStamp}}");
        callback.setCalbackBodyType(Callback.CalbackBodyType.JSON);
        callback.addCallbackVar(multi ? "x:waybillNos" : "x:waybillNo", imageInfo.getExpressNumber());
        callback.addCallbackVar("x:opOrgCode", imageInfo.getNameNumber());
        callback.addCallbackVar("x:opCode", imageInfo.getOpCode());
        callback.addCallbackVar("x:snNumber", imageInfo.getSnNumber());
        callback.addCallbackVar("x:imgSource", this.commonConfig.getAppId());
        callback.addCallbackVar("x:operateTimeStamp", imageInfo.getExtend());
        return callback;
    }

    private boolean isMultiWaybillNo(String expressNumber) {
        if (expressNumber.contains(",")) {
            String[] split = expressNumber.split(",");
            return split.length > 1;
        }
        return false;
    }

    public List<ImagePushToServerEntity> supplementUpload() {
        if (this.commonConfig.getUploadImageSwitch() != 1) {
            return null;
        }
        return this.expImageUploadInfoService.getDataListFromQueue();
    }

    public BizTypeEnum getBizType() {
        return BizTypeEnum.Task_Image;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        int uploadImageMaxPoolSize = this.commonConfig.getUploadImageMaxBandWidth() / 10;
        if (uploadImageMaxPoolSize <= 0) {
            uploadImageMaxPoolSize = 3;
        } else if (uploadImageMaxPoolSize > 30) {
            uploadImageMaxPoolSize = 30;
        }
        return new ThreadPoolExecutor(this.commonConfig.getUploadImageCorePoolSize(), uploadImageMaxPoolSize, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), (ThreadFactory)new NamedThreadFactory(this.getBizType().getRemark()), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void sendBefore() {
        int speedSize = this.commonConfig.getUploadImageSpeedLimit();
        if (speedSize > 0 && speedSize <= 30) {
            try {
                logger.info("\u56fe\u7247\u4e0a\u4f20\u8bbe\u7f6e\u4e86\u4e0a\u4f20\u901f\u7387");
                Thread.sleep(speedSize * 60 * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendAfter() {
        SubjectObj.change((MessageTypeEnum)MessageTypeEnum.NewTask, (BizTypeEnum)BizTypeEnum.Task_Image_Delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getTokenFromRemote() {
        String string = "success";
        synchronized ("success") {
            if (null != this.clientHolder && this.clientHolder.isTokenOk()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            if (this.clientHolder != null) {
                this.clientHolder.clientShutdown();
            }
            String appId = this.commonConfig.getAppId();
            boolean isUseful = false;
            int count = 3;
            OssTokenReq ossTokenReq = new OssTokenReq(appId);
            do {
                try {
                    NewServerResp tokenResp = (NewServerResp)CommonUtil.sendRequestNoCatch((RestTemplate)this.restTemplate, (String)UrlConfig.MethodEnum.ossToken.getMethod(), (Object)ossTokenReq, null, (HttpHeaders)this.getHeader(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    if (tokenResp != null && "200".equals(tokenResp.getCode()) && tokenResp.getData() != null) {
                        logger.info("Token\u83b7\u53d6\u6210\u529f,\u8fc7\u671f\u65f6\u95f4\uff1a{},endPoint\uff1a{}", (Object)DateUtil.formatDate((Date)((OssClientHolder)tokenResp.getData()).getExpirationTime()), (Object)((OssClientHolder)tokenResp.getData()).getEndPoint());
                        this.clientHolder = (OssClientHolder)tokenResp.getData();
                        this.clientHolder.initOssClient();
                        isUseful = true;
                        break;
                    }
                    logger.error("\u83b7\u53d6token\u54cd\u5e94\u5f02\u5e38\uff1a{}", (Object)JSONObject.toJSONString((Object)tokenResp));
                }
                catch (Exception e) {
                    logger.error("token\u83b7\u53d6\u5f02\u5e38 count\uff1a{}", (Object)count, (Object)e);
                }
            } while (--count > 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return isUseful;
        }
    }

    private HttpHeaders getHeader() {
        String appId = this.commonConfig.getAppId();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = this.securityService.generateCvOssSign(appId, this.commonConfig.getImageUploadKey(), timestamp);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.put("OSS-SIGN", Collections.singletonList(sign));
        httpHeaders.put("OSS-APP-ID", Collections.singletonList(appId));
        httpHeaders.put("OSS-TIMESTAMP", Collections.singletonList(timestamp));
        return httpHeaders;
    }

    private void handleFailUpload(ImagePushToServerEntity imageInfo) {
        imageInfo.setReTryCount(imageInfo.getReTryCount() + 1);
        imageInfo.setStatus(2);
        imageInfo.setMessage("\u4e0a\u4f20\u5931\u8d25");
        imageInfo.setLockTime(DateUtil.addMinute((Date)new Date(), (int)5));
        this.doUploadFailData(imageInfo);
    }

    private void handleSuccessUpload(ImagePushToServerEntity imageInfo) {
        imageInfo.setStatus(1);
        imageInfo.setMessage("\u5df2\u4e0a\u4f20");
        this.doUploadFailData(imageInfo);
    }

    private void doUploadFailData(ImagePushToServerEntity item) {
        this.expImageUploadInfoService.modifyImageUploadInfo(item, null);
    }

    public static ImagePushToServerEntity integrateData(ImageInfoUploadRequestEntity imageInfo, String imagePath) {
        ImagePushToServerEntity entity = new ImagePushToServerEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setExpressNumber(imageInfo.getExpressNumber());
        entity.setNameNumber(imageInfo.getNameNumber());
        entity.setOpCode(imageInfo.getOpCode());
        entity.setSnNumber(imageInfo.getSnNumber());
        entity.setImgSource(imageInfo.getImgSource());
        entity.setExtend(imageInfo.getExtend());
        entity.setImageLocation(imagePath);
        entity.setStatus(0);
        entity.setReTryCount(0);
        entity.setMessage("\u672a\u4e0a\u4f20");
        if ("1".equals(imageInfo.getEncrypted())) {
            entity.setExtend3("1");
        } else if ("2".equals(imageInfo.getEncrypted())) {
            entity.setExtend3("2");
        }
        return entity;
    }

    private static void getImageToken() {
        String appId = "img_Monitor_Adapter";
        String key = "c^n1J#%vnC&ilWoi";
        String url = "http://tpqlc.yto.net.cn:8090/nabs-image-up-api/image/ossAuthorizeToken";
        String sessionName = UUID.randomUUID().toString().replaceAll("-", "");
        try {
            String sign = CommonUtil.doSign((String)(appId + sessionName), (String)"UTF-8", (String)key);
            ImageTokenRequestEntity requestEntity = new ImageTokenRequestEntity(appId, sessionName, sign);
            String response = CommonUtil.sendRequest((RestTemplate)CommonUtil.getRestTemplate((int)10000), (String)url, (Object)requestEntity, null);
            if (response != null) {
                ImageTokenResponse tokenResponse = (ImageTokenResponse)GoogleJsonUtil.toObject((String)response, ImageTokenResponse.class);
                if (tokenResponse != null && ImageTokenRespEnum.SUCCESS.getCode().equals(tokenResponse.getCode())) {
                    System.out.println("Token\u83b7\u53d6\u6210\u529f,\u8fc7\u671f\u65f6\u95f4\uff1a" + DateUtil.formatDate((Date)tokenResponse.getData().getExpirationTime()));
                    System.out.println("token -> " + JSONObject.toJSONString((Object)tokenResponse));
                }
            } else {
                System.out.println("token\u83b7\u53d6\u5931\u8d25\uff0c\u65e0\u6cd5\u8fde\u63a5\u7533\u8bf7token\u7684\u670d\u52a1\u5668 \u6216 \u8bf7\u6c42token\u5931\u8d25 -> " + response);
            }
        }
        catch (RuntimeException e) {
            System.out.println("\u7b7e\u540d\u7b97\u6cd5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5" + e.getCause());
        }
    }

    public static void main(String[] args) {
        TransferImageInfoManager.getImageToken();
    }
}

