/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job.thread.crud;

import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrudBaseManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(CrudBaseManager.class);
    private static final Logger logger_image = CustomLoggerFactory.ImageLogger();
    private ThreadPoolExecutor pool;

    public CrudBaseManager() {
        if (this.pool == null) {
            this.pool = new ThreadPoolExecutor(10, 12, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2900), new ThreadPoolExecutor.CallerRunsPolicy());
            this.pool.allowCoreThreadTimeOut(true);
            this.pool.setKeepAliveTime(10L, TimeUnit.MINUTES);
        }
    }

    private Logger getLogger() {
        if (this.name().equals("\u56fe\u7247\u5220\u9664")) {
            return logger_image;
        }
        return logger;
    }

    protected abstract ThreadPoolExecutor ThreadPoolExecutor();

    protected abstract List<T> getData();

    protected abstract int subListSize();

    protected abstract String name();

    protected abstract void doThings(List<T> var1);

    protected void validateAndCreateTask(AtomicBoolean atomicBoolean) {
        if (this.ThreadPoolExecutor() != null) {
            this.pool = this.ThreadPoolExecutor();
        }
        if (this.subListSize() <= 0) {
            this.createTask(this.pool, atomicBoolean, 200);
        } else {
            this.createTask(this.pool, atomicBoolean, this.subListSize());
        }
    }

    private void createTask(ThreadPoolExecutor pool, AtomicBoolean atomicBoolean, int size) {
        if (atomicBoolean.get()) {
            return;
        }
        atomicBoolean.set(true);
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    static /* synthetic */ Logger access$000(CrudBaseManager x0) {
        return x0.getLogger();
    }
}

