/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job.thread.upload;

import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.job.thread.NamedThreadFactory;
import com.yto.monitor.adapter.job.thread.upload.UploadBaseManager;
import com.yto.monitor.adapter.service.CheckWhiteListService;
import com.yto.monitor.adapter.service.UploadService;
import com.yto.monitor.adapter.service.observer.MessageObj;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UploadManager
extends UploadBaseManager {
    private static final Logger logger = LoggerFactory.getLogger(UploadManager.class);
    @Autowired
    private Map<String, UploadService> serviceMap;
    @Autowired
    private CommonConfig commonConfig;
    private static ThreadPoolExecutor pool;
    @Autowired
    private CheckWhiteListService checkWhiteListService;
    private ConcurrentHashMap<UploadService, AtomicBoolean> mapAtomicBoolean = new ConcurrentHashMap();
    private ConcurrentHashMap<UploadService, ThreadPoolExecutor> mapThreadPoolExecutor = new ConcurrentHashMap();

    public UploadManager() {
        if (pool == null) {
            pool = new ThreadPoolExecutor(5, 50, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), (ThreadFactory)new NamedThreadFactory("\u516c\u7528\u4e0a\u4f20\u7ebf\u7a0b"), new ThreadPoolExecutor.CallerRunsPolicy());
            pool.allowCoreThreadTimeOut(true);
            pool.setKeepAliveTime(10L, TimeUnit.MINUTES);
        }
    }

    public static ThreadPoolExecutor getPool() {
        return pool;
    }

    public void update(MessageObj messageObj) {
        if (this.commonConfig.checkModel(messageObj) == -1) {
            return;
        }
        if (!this.checkWhiteListService.validWhiteList()) {
            logger.info("\u975e\u4e2d\u5fc3\u767d\u540d\u5355\u7981\u7528\u6216\u8005\u5220\u9664\u4e0d\u8fdb\u884c\u6570\u636e\u4e0a\u4f20");
            return;
        }
        for (Map.Entry map : this.serviceMap.entrySet()) {
            ThreadPoolExecutor customPool;
            UploadService uploadService = (UploadService)map.getValue();
            if (uploadService.getBizType() == null) continue;
            if (!this.mapAtomicBoolean.containsKey(uploadService)) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                this.mapAtomicBoolean.put(uploadService, atomicBoolean);
            }
            if (!this.mapThreadPoolExecutor.containsKey(uploadService) && (customPool = uploadService.getThreadPoolExecutor()) != null) {
                customPool.allowCoreThreadTimeOut(true);
                customPool.setKeepAliveTime(10L, TimeUnit.MINUTES);
                this.mapThreadPoolExecutor.put(uploadService, customPool);
            }
            if (this.mapThreadPoolExecutor.containsKey(uploadService)) {
                this.validateAndCreateTask(messageObj, (ThreadPoolExecutor)this.mapThreadPoolExecutor.get(uploadService), uploadService, (AtomicBoolean)this.mapAtomicBoolean.get(uploadService));
                continue;
            }
            this.validateAndCreateTask(messageObj, pool, uploadService, (AtomicBoolean)this.mapAtomicBoolean.get(uploadService));
        }
    }
}

