/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.job.thread.upload;

import com.yto.monitor.adapter.job.thread.upload.UploadTaskProxy;
import com.yto.monitor.adapter.service.UploadService;
import com.yto.monitor.adapter.service.impl.NewExpOperUploadService;
import com.yto.monitor.adapter.service.observer.BizTypeEnum;
import com.yto.monitor.adapter.utils.LoggerHelper;
import com.yto.monitor.common.util.HttpClientConnectionStatusUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class UploadTaskProxy {
    private ThreadPoolExecutor pool;
    private UploadService uploadService;
    private String remark;
    private int maxPoolSize;

    public UploadTaskProxy(ThreadPoolExecutor pool, UploadService uploadService) {
        this.pool = pool;
        this.uploadService = uploadService;
        this.remark = uploadService.getBizType().getRemark();
        this.maxPoolSize = pool.getMaximumPoolSize();
    }

    private Logger getLogger() {
        return LoggerHelper.getLogger(UploadTaskProxy.class, (BizTypeEnum)this.getBizType());
    }

    public int sendToServer(List list) {
        this.GroupingDataUpload(list);
        return 0;
    }

    public void triggerTaskExecute() {
        while (HttpClientConnectionStatusUtil.isOnLine() != Boolean.FALSE) {
            Long start = System.currentTimeMillis();
            List list = this.uploadService.supplementUpload();
            if (!this.uploadService.getBizType().equals((Object)BizTypeEnum.Task_Operation) && CollectionUtils.isEmpty((Collection)list)) break;
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            this.getLogger().info("{},\u62c9\u53d6\u6570\u636e{}\u6761\u8017\u65f6:{}ms", new Object[]{this.getBizType().getRemark(), list.size(), System.currentTimeMillis() - start});
            this.sendBefore();
            this.sendToServer(list);
            this.sendAfter();
        }
    }

    public BizTypeEnum getBizType() {
        return this.uploadService.getBizType();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return null;
    }

    public void sendBefore() {
        this.uploadService.sendBefore();
    }

    public void sendAfter() {
        this.uploadService.sendAfter();
    }

    private void GroupingDataUpload(List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.getLogger().warn("\u4e0a\u4f20\u4ee3\u7406\u7c7b\u6536\u5230\u6570\u636e\u4e3a\u7a7a\uff01\u4e0d\u4e88\u4e0a\u4f20!");
            return;
        }
        int size = list.size();
        if (this.uploadService.getBizType().equals((Object)BizTypeEnum.Task_LatticeNo)) {
            this.GroupingDataUpload(list, list.size());
        } else if (this.uploadService.getBizType().equals((Object)BizTypeEnum.Task_Image)) {
            int max = size % this.maxPoolSize == 0 ? size / this.maxPoolSize : size / this.maxPoolSize + 1;
            this.GroupingDataUpload(list, max);
        } else if (this.uploadService.getBizType().equals((Object)BizTypeEnum.Task_Operation)) {
            this.GroupingDataUpload(list, NewExpOperUploadService.UPLOAD_SIZE);
        } else {
            int max = size > 0 && size <= 100 ? 10 : (size > 100 && size <= 200 ? 20 : (size > 200 && size <= 500 ? 50 : (size > 500 && size <= 1500 ? 100 : (size > 1500 && size <= 3000 ? 150 : 200))));
            this.GroupingDataUpload(list, max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GroupingDataUpload(List list, int num) {
        long start = System.currentTimeMillis();
        int dataSize = list.size();
        int max = num;
        int merchant = dataSize / max;
        int remainder = dataSize % max;
        int count = 0;
        if (merchant == 0) {
            ++count;
        } else if (merchant > 0 && remainder == 0) {
            count = merchant;
        } else if (merchant > 0 && remainder > 0) {
            count = merchant + 1;
        }
        this.getLogger().info("{}-\u7ebf\u7a0b\u7ec4\u4e0a\u4f20\u5f00\u59cb,\u6700\u5927\u7ebf\u7a0b\u6570[{}]...\u5171\u8ba1:{},\u5206:{}\u9875\u4e0a\u4f20,\u6bcf\u9875:{}", new Object[]{this.remark, this.maxPoolSize, dataSize, count, max});
        if (max > 200) {
            this.getLogger().warn("\u8b66\u544a\uff01\u5355\u9875\u5904\u7406\u7684\u6570\u636e\u91cf\u8fc7\u8f7d,\u8bf7\u5408\u7406\u8bbe\u7f6e\u7ebf\u7a0b\u6c60\u4e0e\u5206\u9875\u5927\u5c0f\u7684\u5173\u7cfb...");
        }
        CountDownLatch latch = new CountDownLatch(count);
        List cutList = null;
        for (int j = 0; j < count; ++j) {
            cutList = j == count - 1 ? list.subList(max * j, dataSize) : list.subList(max * j, max * (j + 1));
            List listStr = cutList;
            UploadTaskRunnable taskRunnable = new UploadTaskRunnable(this);
            taskRunnable.setLatch(latch);
            taskRunnable.setList(listStr);
            this.pool.execute((Runnable)taskRunnable);
        }
        try {
            latch.await(1L, TimeUnit.HOURS);
            if (latch.getCount() == 0L) {
                this.getLogger().info("{}-\u7ebf\u7a0b\u7ec4\u4e0a\u4f20\u5b8c\u6bd5,\u8017\u65f6\uff1a{}ms", (Object)this.remark, (Object)(System.currentTimeMillis() - start));
            } else {
                this.getLogger().error("\u8d85\u65f6...{}-\u7ebf\u7a0b\u7ec4\u6267\u884c\u8d85\u65f61\u5c0f\u65f6,\u8bf7\u68c0\u67e5\u4ee3\u7801\u4ee5\u53ca\u7f51\u7edc\u73af\u5883\u662f\u5426\u6b63\u5e38!", (Object)this.remark);
            }
        }
        catch (InterruptedException e) {
            this.getLogger().error(this.remark + "-\u591a\u7ebf\u7a0b\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
        }
        finally {
            latch = null;
        }
    }

    static /* synthetic */ UploadService access$000(UploadTaskProxy x0) {
        return x0.uploadService;
    }

    static /* synthetic */ Logger access$100(UploadTaskProxy x0) {
        return x0.getLogger();
    }
}

