/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.monitor;

import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class ThreadPoolMonitor
implements Runnable {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private ThreadPoolExecutor executor;
    private String poolName;
    private long monitoringPeriod;
    private TimeUnit timeUnit;
    private boolean isDaemon = true;
    private final AtomicLong lastTaskCount = new AtomicLong(0L);

    public ThreadPoolMonitor(ThreadPoolExecutor executor, String poolName, long monitoringPeriod, TimeUnit timeUnit) {
        this.executor = executor;
        this.poolName = poolName;
        this.monitoringPeriod = monitoringPeriod;
        this.timeUnit = timeUnit;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.timeUnit.sleep(this.monitoringPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            try {
                this.monitorThreadPool();
            }
            catch (Exception e) {
                logger.error("\u7ebf\u7a0b\u76d1\u63a7\u65f6,\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void monitorThreadPool() {
        int activeCount = this.executor.getActiveCount();
        int poolSize = this.executor.getPoolSize();
        int corePoolSize = this.executor.getCorePoolSize();
        int maximumPoolSize = this.executor.getMaximumPoolSize();
        long completedTaskCount = this.executor.getCompletedTaskCount();
        long taskCount = this.executor.getTaskCount();
        int queueSize = this.executor.getQueue().size();
        long oldTaskCount = this.lastTaskCount.get();
        long taskIncrement = taskCount - oldTaskCount;
        this.lastTaskCount.set(taskCount);
        double poolUsage = (double)activeCount / (double)maximumPoolSize * 100.0;
        logger.info(String.format("[\u7ebf\u7a0b\u6c60\u76d1\u63a7-%s] \u6d3b\u52a8\u7ebf\u7a0b\u6570: %d, \u5f53\u524d\u7ebf\u7a0b\u6570: %d, \u6838\u5fc3\u7ebf\u7a0b\u6570: %d, \u6700\u5927\u7ebf\u7a0b\u6570: %d, \u5df2\u5b8c\u6210\u4efb\u52a1\u6570: %d, \u603b\u4efb\u52a1\u6570: %d, \u7b49\u5f85\u4efb\u52a1\u6570: %d, \u7ebf\u7a0b\u6c60\u4f7f\u7528\u7387: %.2f%%, \u4efb\u52a1\u589e\u957f\u6570: %d", this.poolName, activeCount, poolSize, corePoolSize, maximumPoolSize, completedTaskCount, taskCount, queueSize, poolUsage, taskIncrement));
        this.checkThreadPoolStatus(activeCount, maximumPoolSize, queueSize);
    }

    private void checkThreadPoolStatus(int activeCount, int maximumPoolSize, int queueSize) {
        if ((double)activeCount / (double)maximumPoolSize >= 0.8) {
            logger.warn(String.format("[\u7ebf\u7a0b\u6c60\u544a\u8b66-%s] \u7ebf\u7a0b\u6c60\u8d1f\u8f7d\u8fc7\u9ad8! \u6d3b\u52a8\u7ebf\u7a0b\u6570: %d, \u6700\u5927\u7ebf\u7a0b\u6570: %d", this.poolName, activeCount, maximumPoolSize));
        }
        int queueCapacity = this.executor.getQueue().remainingCapacity() + queueSize;
        if (queueSize > 0 && (double)queueSize / (double)queueCapacity >= 0.8) {
            logger.warn(String.format("[\u7ebf\u7a0b\u6c60\u544a\u8b66-%s] \u961f\u5217\u79ef\u538b\u4e25\u91cd! \u5f53\u524d\u961f\u5217\u4efb\u52a1\u6570: %d, \u961f\u5217\u5bb9\u91cf: %d", this.poolName, queueSize, queueCapacity));
        }
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    public void start() {
        Thread monitor = new Thread((Runnable)this, "ThreadPool-Monitor-" + this.poolName);
        monitor.setDaemon(this.isDaemon);
        monitor.start();
    }
}

