/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mpush.listener;

import cn.yto.ypush.spring.annotation.YPushMessageListener;
import cn.yto.ypush.spring.core.YPushListener;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yto.monitor.adapter.constant.SendStatus;
import com.yto.monitor.adapter.entity.DeviceActive;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.service.DeviceActiveService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@YPushMessageListener(msgId=8304)
public class ActiveChangeEventListener
implements YPushListener<String> {
    private static final Logger logger = CustomLoggerFactory.MpushLogger();
    @Autowired
    private DeviceActiveService deviceActiveService;
    @Autowired
    private IExpAutoDeviceService autoDeviceService;

    public synchronized void onMessage(String s) {
        logger.info("\u6536\u5230\u8bbe\u5907\u6fc0\u6d3b\u7801\u63a8\u9001\uff1a{}", (Object)s);
        if (StringUtils.isBlank((String)s)) {
            return;
        }
        DeviceActive data = (DeviceActive)JSONObject.parseObject((String)s, DeviceActive.class);
        if (data == null || StringUtils.isBlank((String)data.getDeviceSeq()) || StringUtils.isBlank((String)data.getBindStatus()) || "1".equals(data.getBindStatus()) && StringUtils.isBlank((String)data.getDeviceId())) {
            return;
        }
        boolean exception = false;
        try {
            this.deviceActiveService.remove((Wrapper)new LambdaQueryWrapper().eq(DeviceActive::getDeviceSeq, (Object)data.getDeviceSeq()));
            if (data.getDeleted().booleanValue()) {
                this.cleanDeviceSeq(data);
            } else {
                this.deviceActiveService.save((Object)data);
                if ("0".equals(data.getBindStatus())) {
                    this.cleanDeviceSeq(data);
                }
                if ("1".equals(data.getBindStatus())) {
                    this.deviceActiveService.againBind(data);
                }
            }
        }
        catch (Exception e) {
            exception = true;
            logger.error("\u5904\u7406\u6fc0\u6d3b\u7801\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
        if (!exception && data.getEffective().booleanValue()) {
            this.deviceActiveService.noticeBusiGatewayCheckBind();
        }
    }

    public void cleanDeviceSeq(DeviceActive data) {
        TExpAutoDevice device = new TExpAutoDevice();
        device.setDeviceSeq("");
        device.setModifyTime(new Date());
        device.setSendStatus(Integer.valueOf(SendStatus.UPDATE.getStatus()));
        device.setSendMsg(SendStatus.UPDATE.getMsg());
        this.autoDeviceService.update((Object)device, (Wrapper)new UpdateWrapper().lambda().eq(TExpAutoDevice::getDeviceSeq, (Object)data.getDeviceSeq()));
    }
}

