/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mpush.listener;

import cn.yto.ypush.spring.annotation.YPushMessageListener;
import cn.yto.ypush.spring.core.YPushListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yto.monitor.adapter.config.CommonConfig;
import com.yto.monitor.adapter.entity.AlarmLight;
import com.yto.monitor.adapter.entity.AlarmRemind;
import com.yto.monitor.adapter.netty.server.framework.business.datastruct.SocketClientObj;
import com.yto.monitor.adapter.netty.server.light.LightGateWay;
import com.yto.monitor.adapter.service.AlarmLightService;
import com.yto.monitor.adapter.utils.AlarmMsgHelper;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.GoogleJsonUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@YPushMessageListener(msgId=8301)
public class ConsumingMsgServiceImpl
implements YPushListener<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MpushLogger();
    public static final Long INTERVAL = 300000L;
    @Autowired
    private AlarmLightService alarmLightService;
    public static ConcurrentHashMap<String, Long> lightSendTimeMap = new ConcurrentHashMap();
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private LightGateWay lightGateWay;

    public void onMessage(String message) {
        LOGGER.info("\u63a8\u9001\u6536\u5230mpush\u8fc7\u6765\u76848301\u6570\u636e,msg:{},thread:{}", (Object)message, (Object)Thread.currentThread());
        AlarmRemind alarmRemind = (AlarmRemind)GoogleJsonUtil.toObject((String)message, AlarmRemind.class);
        String cameraId = alarmRemind.getCameraId();
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StringUtils.isNotBlank((CharSequence)cameraId), AlarmLight::getCameraIndexCode, (Object)cameraId);
        List list = this.alarmLightService.list((Wrapper)eq);
        if (CollectionUtils.isEmpty((Collection)list)) {
            LOGGER.info("\u6839\u636ecameraId:{}, \u672a\u627e\u5230alarm light\u7684ip", (Object)cameraId);
            return;
        }
        AlarmLight alarmLight = (AlarmLight)list.get(0);
        String ip = alarmLight.getIp();
        SocketClientObj socketClientObj = this.lightGateWay.getSocketClientObj(ip);
        if (Objects.isNull(socketClientObj) || !socketClientObj.channel.isOpen()) {
            LOGGER.info("\u6839\u636eip{},\u672a\u627e\u5230\u53ef\u7528\u7684socket \u8fde\u63a5", (Object)ip);
            return;
        }
        String msg = AlarmMsgHelper.genDiffMsgByMode((String)"1", (String)"01", (String)"10", (String)"001A", (String)"4", (String[])this.commonConfig.getAlarmLightConf());
        boolean b = socketClientObj.sendHexData(msg, LOGGER);
        if (b) {
            lightSendTimeMap.put(ip, System.currentTimeMillis());
        }
    }

    public void needSendTurnOffMsg() {
        if (!MapUtils.isEmpty((Map)lightSendTimeMap)) {
            Iterator iterator = lightSendTimeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if ((Long)next.getValue() + INTERVAL > System.currentTimeMillis()) continue;
                SocketClientObj socketClientObj = this.lightGateWay.getSocketClientObj((String)next.getKey());
                if (Objects.nonNull(socketClientObj) && socketClientObj.channel.isOpen()) {
                    String msg = AlarmMsgHelper.genDiffMsgByMode((String)"0", (String)"01", (String)"10", (String)"001A", (String)"4", (String[])this.commonConfig.getAlarmLightConf());
                    LOGGER.info("\u706f\u4eae\u8d85\u8fc75\u5206\u949f \u51c6\u5907\u53d1\u9001\u706d\u706f\u62a5\u6587\uff1a{}", (Object)msg);
                    socketClientObj.sendHexData(msg, LOGGER);
                }
                iterator.remove();
            }
        }
    }
}

