/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.autoconfigure;

import com.yto.monitor.adapter.mqtt.client.EmqTemplate;
import com.yto.monitor.adapter.mqtt.event.MqttEventBus;
import com.yto.monitor.adapter.mqtt.event.MqttThreadPoolManager;
import com.yto.monitor.adapter.mqtt.properties.MqttConfigProperties;
import com.yto.monitor.adapter.mqtt.subscribe.MqttSubscribeListener;
import com.yto.monitor.adapter.mqtt.support.MqttContainer;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.StandardEnvironment;

@Configuration
@EnableConfigurationProperties(value={MqttConfigProperties.class})
public class MqttContainerConfiguration
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private StandardEnvironment environment;
    private MqttConfigProperties properties;

    public MqttContainerConfiguration(StandardEnvironment environment, MqttConfigProperties properties) {
        this.environment = environment;
        this.properties = properties;
        MqttThreadPoolManager manager = new MqttThreadPoolManager();
        MqttEventBus.create((Executor)manager.getConsumeExecutor());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Bean
    public MqttContainer mqttContainer() {
        MqttContainer container = new MqttContainer(this.properties);
        return container;
    }

    @Bean
    @ConditionalOnBean(value={MqttContainer.class})
    public EmqTemplate emqTemplate(MqttContainer mqttContainer) {
        EmqTemplate template = new EmqTemplate();
        template.setMqttClient(mqttContainer.getMqttClient());
        return template;
    }

    @Bean
    @ConditionalOnBean(value={EmqTemplate.class})
    public MqttSubscribeListener emqSubscribeConsumer(EmqTemplate emqTemplate) {
        MqttSubscribeListener emqSubscribeConsumer = new MqttSubscribeListener();
        emqSubscribeConsumer.setEmqTemplate(emqTemplate);
        emqSubscribeConsumer.setProperties(this.properties);
        return emqSubscribeConsumer;
    }
}

