/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.client;

import com.yto.monitor.adapter.mqtt.enums.QoSEnum;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;

public class EmqTemplate {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    private IMqttClient mqttClient;

    public boolean publish(String topic, String msg, QoSEnum qos, boolean retain) {
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setPayload(msg.getBytes(StandardCharsets.UTF_8));
        mqttMessage.setQos(qos.getValue());
        mqttMessage.setRetained(retain);
        try {
            LOGGER.info("mqtt client begin send to topic={},msg={},qos={},retain={}", new Object[]{topic, msg, qos.getValue(), retain});
            this.mqttClient.publish(topic, mqttMessage);
            LOGGER.info("mqtt client  send to topic={} success,msg={}", (Object)topic, (Object)msg);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("mqtt client publish fail,errormsg={},topic={},msg={},qos={},retain={}", new Object[]{e.getMessage(), topic, msg, qos.getValue(), retain});
            return false;
        }
    }

    public boolean subscribe(String topicFilter, QoSEnum qos) {
        try {
            LOGGER.info("mqtt client begin  to subscribe topic={},qos={}", (Object)topicFilter, (Object)qos.getValue());
            this.mqttClient.subscribe(topicFilter, qos.getValue());
            LOGGER.info("mqtt client subscribe success,topic={},qos={}", (Object)topicFilter, (Object)qos.getValue());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("mqtt client subscribe fail,errormsg={},topic={},qos={}", new Object[]{e.getMessage(), topicFilter, qos.getValue()});
            return false;
        }
    }

    public boolean subscribe(String[] topicFilters, int[] qos) {
        try {
            LOGGER.info("mqtt client begin  to subscribe topic={},qos={}", (Object)Arrays.toString(topicFilters), (Object)Arrays.toString(qos));
            this.mqttClient.subscribe(topicFilters, qos);
            LOGGER.info("mqtt client subscribe success,topic={},qos={}", (Object)Arrays.toString(topicFilters), (Object)Arrays.toString(qos));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("mqtt client subscribe fail,errormsg={},topic={},qos={}", new Object[]{e.getMessage(), topicFilters, qos});
            return false;
        }
    }

    public boolean unsubscribe(String topic) {
        try {
            LOGGER.info("mqtt client begin  to unsubscribe topic={}", (Object)topic);
            this.mqttClient.unsubscribe(topic);
            LOGGER.info("mqtt client unsubscribe success,topic={}", (Object)topic);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("mqtt client unsubscribe fail,errormsg={},topic={}", (Object)e.getMessage(), (Object)topic);
            return false;
        }
    }

    public void setMqttClient(IMqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }
}

