/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.client;

import com.yto.monitor.adapter.mqtt.event.MqttConnectionCloseEvent;
import com.yto.monitor.adapter.mqtt.event.MqttConnectionConnectEvent;
import com.yto.monitor.adapter.mqtt.event.MqttEvent;
import com.yto.monitor.adapter.mqtt.event.MqttEventBus;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerFactory;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttMessageConsumer;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;

public class MqttMessageCallback
implements MqttCallbackExtended {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();

    public void connectionLost(Throwable throwable) {
        MqttEventBus.post((MqttEvent)new MqttConnectionCloseEvent(throwable));
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String msg = new String(message.getPayload(), StandardCharsets.UTF_8);
        LOGGER.info("\u8ba2\u9605\u5230\u6d88\u606f,topic={},messageid={},qos={},payload={}", new Object[]{topic, message.getId(), message.getQos(), msg});
        String subTopic = topic.substring(topic.lastIndexOf("/") + 1);
        MqttMessageConsumer consumer = MqttConsumerFactory.getInstance().selectConsumer(subTopic);
        if (consumer != null) {
            consumer.pullMessage(msg);
        } else {
            LOGGER.info("No matched consumer for the PullRequest");
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void connectComplete(boolean broker, String s) {
        LOGGER.info("mqtt client connect broker:{} success,isReConnect:{}", (Object)s, (Object)broker);
        MqttEventBus.post((MqttEvent)new MqttConnectionConnectEvent());
    }
}

