/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.event;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.yto.monitor.adapter.mqtt.event.MqttEvent;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttEventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttEventBus.class);
    private static EventBus eventBus;

    public static void create(Executor executor) {
        eventBus = new AsyncEventBus(executor, (exception, context) -> LOGGER.error("event bus subscriber ex", exception));
    }

    public static void post(MqttEvent event) {
        eventBus.post((Object)event);
    }

    public static void register(Object bean) {
        eventBus.register(bean);
    }

    public static void unregister(Object bean) {
        eventBus.unregister(bean);
    }
}

