/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.consumer;

import cn.yto.ypush.common.ThreadFactoryImpl;
import com.yto.monitor.adapter.mqtt.message.consumer.ConsumeMessageService;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerStart;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttMessageConsumer;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeMessageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeMessageService.class);
    private final MqttMessageConsumer mqttMessageConsumer;
    private final MqttConsumerStart consumerStart;
    private final MqttMsgService mqttMsgService;
    private final BlockingQueue<Runnable> consumeRequestQueue;
    private final ThreadPoolExecutor consumeExecutor;
    private final String consumerGroup;

    public ConsumeMessageService(MqttMessageConsumer mqttMessageConsumer, MqttMsgService mqttMsgService) {
        this.mqttMessageConsumer = mqttMessageConsumer;
        this.mqttMsgService = mqttMsgService;
        this.consumerStart = this.mqttMessageConsumer.getMqttConsumerStart();
        this.consumerGroup = this.consumerStart.getTopicGroup();
        this.consumeRequestQueue = new LinkedBlockingQueue();
        this.consumeExecutor = new ThreadPoolExecutor(this.consumerStart.getConsumeThreadMin(), this.consumerStart.getConsumeThreadMax(), 60000L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.consumeRequestQueue, (ThreadFactory)new ThreadFactoryImpl("ConsumeMessageThread_"));
    }

    public void start() {
    }

    public void shutdown() {
        this.consumeExecutor.shutdown();
    }

    public void sumitConsumeRequest(String msg) {
        ConsumeRequest consumeRequest = new ConsumeRequest(this, msg);
        try {
            this.consumeExecutor.submit((Runnable)consumeRequest);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Exception thrown by an Executor when a task cannot accepted for execution.", (Throwable)e);
        }
    }

    static /* synthetic */ MqttMsgService access$000(ConsumeMessageService x0) {
        return x0.mqttMsgService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

