/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.consumer;

import com.yto.monitor.adapter.mqtt.enums.ServiceState;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerFactory;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttMessageConsumer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConsumerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttConsumerFactory.class);
    private final ConcurrentMap<String, MqttMessageConsumer> consumerTable = new ConcurrentHashMap();
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private static MqttConsumerFactory instance = new MqttConsumerFactory();

    public static MqttConsumerFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        MqttConsumerFactory mqttConsumerFactory = this;
        synchronized (mqttConsumerFactory) {
            switch (1.$SwitchMap$com$yto$monitor$adapter$mqtt$enums$ServiceState[this.serviceState.ordinal()]) {
                case 1: {
                    this.serviceState = ServiceState.START_FAILED;
                    LOGGER.info("the MQTT Consumer Factory start OK");
                    this.serviceState = ServiceState.RUNNING;
                    break;
                }
                case 2: {
                    throw new Exception("the MQTT Consumer Factory start  has been created before, and failed.", null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.consumerTable.isEmpty()) {
            return;
        }
        MqttConsumerFactory mqttConsumerFactory = this;
        synchronized (mqttConsumerFactory) {
            switch (1.$SwitchMap$com$yto$monitor$adapter$mqtt$enums$ServiceState[this.serviceState.ordinal()]) {
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    }

    public boolean registerConsumer(String topic, MqttMessageConsumer consumer) {
        if (null == topic || null == consumer) {
            return false;
        }
        MqttMessageConsumer prev = this.consumerTable.putIfAbsent(topic, consumer);
        if (prev != null) {
            LOGGER.warn("the consumer group[" + topic + "] exist already.");
            return false;
        }
        return true;
    }

    public void unregisterConsumer(String group) {
        this.consumerTable.remove(group);
    }

    public MqttMessageConsumer selectConsumer(String group) {
        return (MqttMessageConsumer)this.consumerTable.get(group);
    }
}

