/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.consumer;

import com.yto.monitor.adapter.mqtt.enums.ServiceState;
import com.yto.monitor.adapter.mqtt.message.consumer.ConsumeMessageService;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerFactory;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerStart;
import com.yto.monitor.adapter.mqtt.message.consumer.MqttMessageConsumer;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessageConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttMessageConsumer.class);
    private final MqttConsumerStart mqttConsumerStart;
    private ConsumeMessageService consumeMessageService;
    private volatile ServiceState serviceState = ServiceState.CREATE_JUST;
    private MqttConsumerFactory mqttConsumerFactory;
    private MqttMsgService mqttMsgService;

    public MqttMsgService getMqttListenerService() {
        return this.mqttMsgService;
    }

    public void setMqttListenerService(MqttMsgService mqttMsgService) {
        this.mqttMsgService = mqttMsgService;
    }

    public MqttMessageConsumer(MqttConsumerStart mqttConsumerStart) {
        this.mqttConsumerStart = mqttConsumerStart;
    }

    public String groupName() {
        return this.mqttConsumerStart.getTopicGroup();
    }

    public synchronized void shutdown() {
        switch (1.$SwitchMap$com$yto$monitor$adapter$mqtt$enums$ServiceState[this.serviceState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.consumeMessageService.shutdown();
                this.mqttConsumerFactory.unregisterConsumer(this.mqttConsumerStart.getTopicGroup());
                this.mqttConsumerFactory.shutdown();
                LOGGER.info("the consumer [{}] shutdown OK", (Object)this.mqttConsumerStart.getTopicGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public synchronized void start() throws Exception {
        switch (1.$SwitchMap$com$yto$monitor$adapter$mqtt$enums$ServiceState[this.serviceState.ordinal()]) {
            case 1: {
                this.serviceState = ServiceState.START_FAILED;
                this.mqttConsumerFactory = MqttConsumerFactory.getInstance();
                this.consumeMessageService = new ConsumeMessageService(this, this.mqttConsumerStart.getMqttMsgService());
                this.consumeMessageService.start();
                boolean registerOK = this.mqttConsumerFactory.registerConsumer(this.mqttConsumerStart.getTopicGroup(), this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    this.consumeMessageService.shutdown();
                    throw new Exception("The consumer topic[" + this.mqttConsumerStart.getTopicGroup() + "] has been created before, specify another name please.", null);
                }
                this.mqttConsumerFactory.start();
                LOGGER.info("the consumer topic [{}] start OK.", (Object)this.mqttConsumerStart.getTopicGroup());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                throw new Exception("The MQTTConsumer service state not OK, maybe started once, " + this.serviceState, null);
            }
        }
    }

    public MqttConsumerStart getMqttConsumerStart() {
        return this.mqttConsumerStart;
    }

    public ConsumeMessageService getConsumeMessageService() {
        return this.consumeMessageService;
    }

    public void setConsumeMessageService(ConsumeMessageService consumeMessageService) {
        this.consumeMessageService = consumeMessageService;
    }

    public void pullMessage(String msg) {
        this.consumeMessageService.sumitConsumeRequest(msg);
    }
}

