/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.listener;

import com.yto.monitor.adapter.mqtt.message.consumer.MqttConsumerStart;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import java.lang.reflect.Type;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class MqttListenerContainer
implements InitializingBean,
DisposableBean,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqttListenerContainer.class);
    private ApplicationContext applicationContext;
    private String topic;
    private int consumeThreadMax = 64;
    private String charset = "UTF-8";
    private MqttMsgService mqttMsgService;
    private MqttConsumerStart mqttConsumerStart;
    private Type messageType;
    private boolean running;
    private String selectorExpression;

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MqttMsgService getMqttMsgService() {
        return this.mqttMsgService;
    }

    public void setMqttMsgService(MqttMsgService mqttMsgService) {
        this.mqttMsgService = mqttMsgService;
    }

    public MqttConsumerStart getMqttConsumerStart() {
        return this.mqttConsumerStart;
    }

    public void setMqttConsumerStart(MqttConsumerStart mqttConsumerStart) {
        this.mqttConsumerStart = mqttConsumerStart;
    }

    public Type getMessageType() {
        return this.messageType;
    }

    public void setMessageType(Type messageType) {
        this.messageType = messageType;
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.mqttConsumerStart)) {
            this.mqttConsumerStart.shutdown();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.mqttConsumerStart.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start mqtt consumer", e);
        }
        this.setRunning(true);
        log.info("running container: {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.mqttConsumerStart)) {
                this.mqttConsumerStart.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initMQTTConsumerStart();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        return "MQTTListenerContainer{, topic='" + this.topic + '\'' + '}';
    }

    private void initMQTTConsumerStart() {
        if (this.mqttMsgService == null) {
            throw new IllegalArgumentException("Property 'mqttListenerService' is required");
        }
        Assert.notNull((Object)this.topic, (String)"Property 'consumerGroup' is required");
        this.mqttConsumerStart = new MqttConsumerStart(this.topic);
        this.mqttConsumerStart.setMqttMsgService(this.mqttMsgService);
    }
}

