/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.listener;

import com.yto.monitor.adapter.mqtt.message.listener.MqttListenerContainer;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.StandardEnvironment;

@Configuration
public class MqttListenerContainerConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttListenerContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private AtomicLong counter = new AtomicLong(0L);
    private StandardEnvironment environment;

    public MqttListenerContainerConfiguration(StandardEnvironment environment) {
        this.environment = environment;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(MqttMsg.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach((arg_0, arg_1) -> this.registerContainer(arg_0, arg_1));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    private void registerContainer(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!MqttMsgService.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + MqttMsgService.class.getName());
        }
        MqttMsg annotation = clazz.getAnnotation(MqttMsg.class);
        String containerBeanName = String.format("%s_%s", MqttListenerContainer.class.getName(), this.counter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, MqttListenerContainer.class, () -> this.createMQTTListenerContainer(bean, annotation), new BeanDefinitionCustomizer[0]);
        MqttListenerContainer container = (MqttListenerContainer)genericApplicationContext.getBean(containerBeanName, MqttListenerContainer.class);
        if (!container.isRunning()) {
            try {
                container.start();
            }
            catch (Exception e) {
                LOGGER.error("Started MQTTListenerContainer failed. {}", (Object)container, (Object)e);
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    private MqttListenerContainer createMQTTListenerContainer(Object bean, MqttMsg annotation) {
        MqttListenerContainer container = new MqttListenerContainer();
        container.setTopic(this.environment.resolvePlaceholders(annotation.topic()));
        if (MqttMsgService.class.isAssignableFrom(bean.getClass())) {
            container.setMqttMsgService((MqttMsgService)bean);
        }
        return container;
    }
}

