/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.producer;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.entity.mqtt.CommandPushRespEntity;
import com.yto.monitor.adapter.entity.mqtt.MqttCommonMsg;
import com.yto.monitor.adapter.mqtt.client.EmqTemplate;
import com.yto.monitor.adapter.mqtt.enums.QoSEnum;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.entity.LatticeSchemePushEntity;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.TerminalNetUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqttSendService {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static String QUERT_COUNT_TOPIC_REQ = "sys/business_send/%s/count_resp/up_raw";
    public static String LATTICE_SCHEME_PUSH_TOPIC = "sys/business/%s/7404";
    @Autowired
    private EmqTemplate emqTemplate;

    public void sendQueryMsg(CommandPushRespEntity commandPushRespEntity, String tableName) {
        MqttCommonMsg mqttMessage = new MqttCommonMsg();
        this.setDefaultValue(commandPushRespEntity);
        mqttMessage.setData((Object)commandPushRespEntity);
        String topic = String.format(QUERT_COUNT_TOPIC_REQ, commandPushRespEntity.getOrgCode());
        boolean result = this.emqTemplate.publish(topic, JSONObject.toJSONString((Object)mqttMessage), QoSEnum.QoS0, false);
        if (result) {
            logger.info("\u8868:{}\u67e5\u8be2\u6570\u91cf\u4e0a\u62a5\u6210\u529f", (Object)tableName);
        } else {
            logger.info("\u8868:{}\u67e5\u8be2\u6570\u91cf\u4e0a\u62a5\u5931\u8d25", (Object)tableName);
        }
    }

    public void setDefaultValue(CommandPushRespEntity commandPushRespEntity) {
        if (ExpUtils.isBlank((String)commandPushRespEntity.getOrgCode())) {
            commandPushRespEntity.setOrgCode(SysPropertiesConfig.getOrgCode());
        }
        if (ExpUtils.isBlank((String)commandPushRespEntity.getIpAddress())) {
            commandPushRespEntity.setIpAddress(TerminalNetUtil.mulNetworkLocalIp);
        }
    }

    public void sendLatticeSchemeMsg(LatticeSchemePushEntity schemePushEntity) {
        if (Objects.isNull(schemePushEntity) || ExpUtils.isBlank((String)schemePushEntity.getOrgCode())) {
            return;
        }
        String topic = String.format(LATTICE_SCHEME_PUSH_TOPIC, schemePushEntity.getOrgCode());
        boolean result = this.emqTemplate.publish(topic, JSONObject.toJSONString((Object)schemePushEntity), QoSEnum.QoS0, false);
        if (result) {
            logger.info("\u683c\u53e3\u65b9\u6848\u53d8\u66f4 \u6d88\u606f:{} \u53d1\u9001\u6210\u529f", (Object)JSONObject.toJSONString((Object)schemePushEntity));
        } else {
            logger.info("\u683c\u53e3\u65b9\u6848\u53d8\u66f4 \u6d88\u606f:{} \u53d1\u9001\u5931\u8d25", (Object)JSONObject.toJSONString((Object)schemePushEntity));
        }
    }
}

