/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yto.monitor.adapter.entity.MdmDataVersionItem;
import com.yto.monitor.adapter.entity.MessageRemindEntity;
import com.yto.monitor.adapter.entity.Mqtt8401CleintEntity;
import com.yto.monitor.adapter.entity.mqtt.Mqtt8401Msg;
import com.yto.monitor.adapter.mapper.MessageRemindMapper;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.netty.server.framework.GateWay;
import com.yto.monitor.adapter.service.download.MdmDataVersionService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.BaseDataTypeEnum;
import com.yto.monitor.common.constant.SendTypeEnum;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8401")
public class Mqtt8401ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private MdmDataVersionService mdmDataVersionService;
    @Autowired
    private GateWay gateWay;
    @Autowired
    private MessageRemindMapper remindMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848401\u6d88\u606f:{}", (Object)message);
        boolean isLock = true;
        String lockKey = "";
        try {
            MdmDataVersionItem lockItem;
            Mqtt8401Msg data = (Mqtt8401Msg)GoogleJsonUtil.toObject((String)message, Mqtt8401Msg.class);
            String typeStr = data.getType();
            if (ExpUtils.isBlank((String)typeStr)) {
                return;
            }
            String[] split = typeStr.split(",");
            List<String> types = Arrays.asList(split);
            if (types.contains(SendTypeEnum.CLIENT_TYPE.getCode())) {
                Mqtt8401CleintEntity clientEntity = new Mqtt8401CleintEntity();
                BeanUtils.copyProperties((Object)data, (Object)clientEntity);
                clientEntity.setMty("8614");
                clientEntity.setSendTime(new Date(data.getSendTime()));
                JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)clientEntity);
                this.gateWay.notifyAssignedTmwsMac(jsonObject, null);
            }
            if (types.contains(SendTypeEnum.MONITOR_TYPE.getCode())) {
                lockKey = BaseDataTypeEnum.MONITOR_MESSAGE_REMIND.getAction();
                lockItem = this.mdmDataVersionService.acquireMdmVersionLock(lockKey, 30);
                if (lockItem == null) {
                    isLock = false;
                    LOGGER.info("\u672a\u83b7\u53d6\u5230\u9501\u5bf9\u8c61\uff0clockKey\uff1a" + lockKey);
                    return;
                }
                Long messageId = data.getMessageId();
                MessageRemindEntity messageRemindEntity = Optional.ofNullable(messageId).map(id -> {
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"message_id", id);
                    return (MessageRemindEntity)this.remindMapper.selectOne((Wrapper)wrapper);
                }).orElse(null);
                if (Objects.isNull(messageRemindEntity)) {
                    messageRemindEntity = new MessageRemindEntity();
                    BeanUtils.copyProperties((Object)data, (Object)messageRemindEntity);
                    messageRemindEntity.setMessageId(messageId);
                    messageRemindEntity.setSendTime(new Date(data.getSendTime()));
                    messageRemindEntity.setCreateTime(new Date());
                    messageRemindEntity.setUpdateTime(new Date());
                    try {
                        messageRemindEntity.setId(null);
                        this.remindMapper.insert((Object)messageRemindEntity);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63d2\u5165\u6d88\u606f\u5f02\u5e38,messageId:{} \u53ef\u80fd\u5df2\u7ecf\u5165\u5e93,\u51fa\u73b0\u5f02\u5e38:{}", (Object)messageId, (Object)e.getMessage());
                    }
                } else {
                    if (Objects.isNull(data.getSendTime()) || Objects.isNull(messageRemindEntity.getSendTime())) {
                        return;
                    }
                    if (data.getSendTime().longValue() != messageRemindEntity.getSendTime().getTime()) {
                        messageRemindEntity.setSendTime(new Date(data.getSendTime()));
                        LambdaUpdateWrapper messageRemindEntityUpdateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(MessageRemindEntity::getMessageId, (Object)messageRemindEntity.getMessageId());
                        int i = this.remindMapper.update((Object)messageRemindEntity, (Wrapper)messageRemindEntityUpdateWrapper);
                        if (i == 1) {
                            LOGGER.info("\u6d88\u606f\u66f4\u65b0\u6210\u529f");
                        } else {
                            LOGGER.info("\u6d88\u606f\u5df2\u88ab\u66f4\u65b0");
                        }
                    }
                }
            }
            if (types.contains(SendTypeEnum.CLIENT_RULE_CHANGE_MSG_TYPE.getCode())) {
                MessageRemindEntity messageRemindEntity;
                lockKey = BaseDataTypeEnum.CLIENT_RULE_CHANGE_MESSAGE_REMIND.getAction();
                lockItem = this.mdmDataVersionService.acquireMdmVersionLock(lockKey, 30);
                if (lockItem == null) {
                    isLock = false;
                    LOGGER.info("\u672a\u83b7\u53d6\u5230\u9501\u5bf9\u8c61\uff0clockKey\uff1a" + lockKey);
                    return;
                }
                String msgId = data.getMsgId();
                if (StringUtils.isBlank((String)msgId)) {
                    LOGGER.error("\u5ba2\u6237\u7aef\u5efa\u5305\u89c4\u5219\u4fee\u6539\u6d88\u606f\u7684msgId\u4e3a\u7a7a\uff01");
                    return;
                }
                String auxOpCode = data.getAuxOpCode();
                if (auxOpCode.toUpperCase().equals("NEW")) {
                    messageRemindEntity = this.selectMessageRemindEntity(msgId);
                    this.insertMessageRemindEntity(messageRemindEntity, data);
                } else {
                    messageRemindEntity = this.selectMessageRemindEntity(msgId);
                    this.insertMessageRemindEntity(messageRemindEntity, data);
                    if (!Objects.isNull(messageRemindEntity)) {
                        BeanUtils.copyProperties((Object)data, (Object)messageRemindEntity);
                        messageRemindEntity.setUpdateTime(new Date());
                        messageRemindEntity.setMessageId(data.getMessageId());
                        messageRemindEntity.setSendTime(new Date(data.getSendTime()));
                        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().set(MessageRemindEntity::getUserIds, null).eq(MessageRemindEntity::getMsgId, (Object)msgId);
                        int i = this.remindMapper.update((Object)messageRemindEntity, (Wrapper)updateWrapper);
                        if (i == 1) {
                            LOGGER.info("\u6d88\u606f\u66f4\u65b0\u6210\u529f");
                        } else {
                            LOGGER.info("\u6d88\u606f\u5df2\u88ab\u66f4\u65b0");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848401\u6d88\u606f:{},\u51fa\u73b0\u5f02\u5e38:{}", new Object[]{message, e.getMessage(), e});
        }
        finally {
            if (isLock && ExpUtils.isNotBlank((String)lockKey)) {
                this.mdmDataVersionService.releaseMdmVersionLock(lockKey);
            }
        }
    }

    private void insertMessageRemindEntity(MessageRemindEntity messageRemindEntity, Mqtt8401Msg data) {
        if (Objects.isNull(messageRemindEntity)) {
            messageRemindEntity = new MessageRemindEntity();
            BeanUtils.copyProperties((Object)data, (Object)messageRemindEntity);
            messageRemindEntity.setMessageId(data.getMessageId());
            messageRemindEntity.setSendTime(new Date(data.getSendTime()));
            messageRemindEntity.setCreateTime(new Date());
            messageRemindEntity.setUpdateTime(new Date());
            try {
                messageRemindEntity.setId(null);
                this.remindMapper.insert((Object)messageRemindEntity);
            }
            catch (Exception e) {
                LOGGER.error("\u63d2\u5165\u6d88\u606f\u5f02\u5e38,messageId:{} \u53ef\u80fd\u5df2\u7ecf\u5165\u5e93,\u51fa\u73b0\u5f02\u5e38:{}", (Object)data.getMessageId(), (Object)e.getMessage());
            }
        }
    }

    private MessageRemindEntity selectMessageRemindEntity(String msgId) {
        LambdaQueryWrapper messageRemindEntityLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MessageRemindEntity::getMsgId, (Object)msgId);
        MessageRemindEntity messageRemindEntity = (MessageRemindEntity)this.remindMapper.selectOne((Wrapper)messageRemindEntityLambdaQueryWrapper);
        return messageRemindEntity;
    }
}

