/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.mqtt.Mqtt8402Msg;
import com.yto.monitor.adapter.mapper.MessageRemindMapper;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.netty.server.framework.GateWay;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.Collections;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8402")
public class Mqtt8402ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private GateWay gateWay;
    @Autowired
    private MessageRemindMapper remindMapper;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848402\u6d88\u606f:{}", (Object)message);
        try {
            JSONObject jsonObject = JSON.parseObject((String)message);
            String mac = jsonObject.getString("operationTableMac");
            String carTag = jsonObject.getString("carTag");
            String bindingStartTime = jsonObject.getString("bindingStartTime");
            String id = jsonObject.getString("id");
            String scheduleDate = jsonObject.getString("scheduleDate");
            String cpNo = jsonObject.getString("cpNo");
            String supplementCpFlag = jsonObject.getString("supplementCpFlag");
            String multipleCars = jsonObject.getString("multipleCars");
            String unloadingPortNum = jsonObject.getString("unloadingPortNum");
            Mqtt8402Msg data = new Mqtt8402Msg();
            data.setBindingStartTime(bindingStartTime);
            data.setContainerNo(carTag);
            data.setBindingStartTime(bindingStartTime);
            data.setMac(mac);
            data.setMty("8615");
            data.setTxId(id);
            data.setCpNo(cpNo);
            data.setSupplementCpFlag(supplementCpFlag);
            data.setScheduleDate(scheduleDate);
            if (StringUtil.isNotBlank((CharSequence)multipleCars)) {
                data.setMultipleCars(Integer.valueOf(Integer.parseInt(multipleCars)));
            }
            if (StringUtil.isNotBlank((CharSequence)unloadingPortNum)) {
                data.setUnloadingPortNum(Integer.valueOf(Integer.parseInt(unloadingPortNum)));
            }
            JSONObject obj = (JSONObject)JSON.toJSON((Object)data);
            this.gateWay.notifyAssignedTmwsMac(obj, Collections.singletonList(mac));
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u64cd\u4f5c\u53f0\u7ed1\u5b9a\u8f66\u7b7e\u6d88\u606f\u63a8\u9001:{},\u51fa\u73b0\u5f02\u5e38:{}", (Object)message, (Object)e.getMessage());
        }
    }
}

