/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.mqtt.Mqtt8403Msg;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.netty.server.framework.GateWay;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.Collections;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8403")
public class Mqtt8403ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private GateWay gateWay;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u88c5\u5378\u5de5\u7ed1\u5b9a\u64cd\u4f5c\u53f0\u6d88\u606f\u63a8\u9001\u76848403\u6d88\u606f:{}", (Object)message);
        try {
            JSONObject jsonObject = JSON.parseObject((String)message);
            String mac = jsonObject.getString("operationTableMac");
            String userCode = jsonObject.getString("staffCode");
            String userName = jsonObject.getString("staffName");
            String bindingStartTime = jsonObject.getString("bindingStartTime");
            String bindingEndTime = jsonObject.getString("bindingEndTime");
            Mqtt8403Msg data = new Mqtt8403Msg();
            data.setUserCode(userCode);
            data.setUserName(userName);
            data.setBindingStartTime(bindingStartTime);
            data.setBindingEndTime(bindingEndTime);
            data.setMty("8616");
            data.setMac(mac);
            JSONObject obj = (JSONObject)JSON.toJSON((Object)data);
            this.gateWay.notifyAssignedTmwsMac(obj, Collections.singletonList(mac));
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u88c5\u5378\u5de5\u7ed1\u5b9a\u64cd\u4f5c\u53f0\u6d88\u606f\u63a8\u9001:{},\u51fa\u73b0\u5f02\u5e38:{}", (Object)message, (Object)e.getMessage());
        }
    }
}

