/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.entity.VersionMonitorEntity;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.VersionService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.ExpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@MqttMsg(topic="8404")
public class Mqtt8404ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private VersionService versionService;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u7684\u6700\u4f4e\u7248\u672c\u7ba1\u63a78404\u6d88\u606f:{}", (Object)message);
        try {
            VersionMonitorEntity versionMonitorEntity = (VersionMonitorEntity)JSONObject.parseObject((String)message, VersionMonitorEntity.class);
            if (Objects.isNull(versionMonitorEntity)) {
                return;
            }
            if (Objects.nonNull(versionMonitorEntity.getAfUpgradeRangeId()) && versionMonitorEntity.getAfUpgradeRangeId() == -1L) {
                this.versionService.downloadMiniVersion();
                return;
            }
            if (Objects.nonNull(versionMonitorEntity.getBfUpgradeRangeId()) && versionMonitorEntity.getBfUpgradeRangeId() == -1L) {
                this.versionService.downloadMiniVersion();
                return;
            }
            String orgCode = SysPropertiesConfig.getOrgCode();
            if (ExpUtils.isBlank((String)orgCode)) {
                LOGGER.info("\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a,\u4e0d\u8fdb\u884c\u66f4\u65b0....");
                return;
            }
            List afCenterCode = versionMonitorEntity.getAfCenterCode();
            if (!CollectionUtils.isEmpty((Collection)afCenterCode) && afCenterCode.contains(orgCode)) {
                this.versionService.downloadMiniVersion();
                return;
            }
            List bfCenterCode = versionMonitorEntity.getBfCenterCode();
            if (!CollectionUtils.isEmpty((Collection)bfCenterCode) && bfCenterCode.contains(orgCode)) {
                this.versionService.downloadMiniVersion();
                return;
            }
            List bfOrgCodes = versionMonitorEntity.getBfOrgCodes();
            if (!CollectionUtils.isEmpty((Collection)bfOrgCodes) && bfOrgCodes.contains(orgCode)) {
                this.versionService.downloadMiniVersion();
                return;
            }
            List afOrgCodes = versionMonitorEntity.getAfOrgCodes();
            if (!CollectionUtils.isEmpty((Collection)afOrgCodes) && afOrgCodes.contains(orgCode)) {
                this.versionService.downloadMiniVersion();
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u7684\u6700\u4f4e\u7248\u672c\u7ba1\u63a78404\u6d88\u606f:{},\u51fa\u73b0\u5f02\u5e38:{}", new Object[]{message, e.getMessage(), e});
        }
    }
}

