/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.yto.monitor.adapter.entity.mqtt.CommandPushEntity;
import com.yto.monitor.adapter.entity.mqtt.CommandPushRespEntity;
import com.yto.monitor.adapter.mapper.QueryCountMapper;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.producer.MqttSendService;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.CmdService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import com.yto.monitor.common.util.TerminalNetUtil;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8405")
public class Mqtt8405ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    public static final String MONITOR_TYPE = "2";
    @Autowired
    QueryCountMapper queryCountMapper;
    @Autowired
    private MqttSendService mqttSendService;
    @Value(value="${server.port}")
    private String serverPort;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848405\u6d88\u606f:{}", (Object)message);
        long startTime = System.currentTimeMillis();
        String localIp = TerminalNetUtil.mulNetworkLocalIp;
        String localPort = this.serverPort;
        CommandPushRespEntity commandPushRespEntity = new CommandPushRespEntity();
        commandPushRespEntity.setAppName(MONITOR_TYPE);
        commandPushRespEntity.setIpAddress(localIp);
        commandPushRespEntity.setAppPort(localPort);
        String tableName = null;
        Integer timeOut = null;
        try {
            CommandPushEntity data = (CommandPushEntity)GoogleJsonUtil.toObject((String)message, CommandPushEntity.class);
            if (data == null) {
                return;
            }
            String ip = data.getBizIp();
            if (ExpUtils.isNotBlank((String)ip) && ExpUtils.isNotBlank((String)localIp) && !localIp.equals(ip)) {
                return;
            }
            Integer port = data.getBizPort();
            if (port != null && ExpUtils.isNotBlank((String)localPort) && !localPort.equals(port.toString())) {
                return;
            }
            String type = data.getGatewayName();
            if (!MONITOR_TYPE.equals(type)) {
                return;
            }
            String command = data.getCommand();
            if (ExpUtils.isBlank((String)command)) {
                return;
            }
            tableName = CmdService.getParam((String)command, (String)"1", (int)CmdService.COMMAND_TYPE_TABLE_COUNT_TABLE_NAME_POS);
            timeOut = CmdService.getParamInt((String)command, (String)"1", (int)CmdService.COMMAND_TYPE_TABLE_COUNT_TIMEOUTE_POS);
            if (ExpUtils.isBlank((String)tableName) || timeOut == null) {
                return;
            }
            String param = "/*+MAX_EXECUTION_TIME(" + timeOut + ")*/";
            int count = this.queryCountMapper.getTableCount(param, tableName);
            Long time = System.currentTimeMillis() - startTime;
            String commandRest = "\u8868:" + tableName + "\u6709" + count + "\u6761\u6570\u636e,\u8017\u65f6" + time + "\u6beb\u79d2";
            commandPushRespEntity.setCommandResult(commandRest);
            this.mqttSendService.sendQueryMsg(commandPushRespEntity, tableName);
        }
        catch (Exception e) {
            Long totaltime = System.currentTimeMillis() - startTime;
            String commandRest = "\u67e5\u8be2\u8868\u6570\u636e\u8d85\u65f6\u6216\u8005\u5f02\u5e38,\u8017\u65f6" + totaltime + "\u6beb\u79d2";
            commandPushRespEntity.setCommandResult(commandRest);
            this.mqttSendService.sendQueryMsg(commandPushRespEntity, tableName);
            LOGGER.info("\u5904\u7406\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848405\u6d88\u606f:{},\u67e5\u8be2\u8d85\u65f6\u6216\u8005\u51fa\u73b0\u5f02\u5e38:{}", (Object)message, (Object)e.getMessage());
        }
    }
}

