/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.entity.MdmDataVersionItem;
import com.yto.monitor.adapter.entity.newDevice.TExpAutoDevice;
import com.yto.monitor.adapter.mqtt.client.EmqTemplate;
import com.yto.monitor.adapter.mqtt.enums.QoSEnum;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.mqtt.message.service.sync.dto.CartDTO;
import com.yto.monitor.adapter.mqtt.message.service.sync.dto.SyncDataReq;
import com.yto.monitor.adapter.mqtt.message.service.sync.dto.SyncDataResp;
import com.yto.monitor.adapter.service.download.MdmDataVersionService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceCartService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceLatticeSectionService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceLatticeService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceMainService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceSupplyService;
import com.yto.monitor.adapter.service.ldt.LdtDeviceSupplyTableService;
import com.yto.monitor.adapter.service.newDevice.IExpAutoDeviceService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.StatusEnum;
import com.yto.monitor.common.entity.base.ldt.LdtDeviceMain;
import com.yto.monitor.common.util.ExpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8406")
public class Mqtt8406ServiceImpl
implements MqttMsgService<String> {
    @Autowired
    private LdtDeviceMainService ldtDeviceMainService;
    @Autowired
    private LdtDeviceSupplyService ldtDeviceSupplyService;
    @Autowired
    private LdtDeviceCartService ldtDeviceCartService;
    @Autowired
    private LdtDeviceLatticeSectionService sectionService;
    @Autowired
    private IExpAutoDeviceService autoDevice;
    @Autowired
    private LdtDeviceSupplyTableService supplyTableService;
    @Autowired
    private LdtDeviceLatticeService latticeService;
    @Autowired
    private EmqTemplate emqTemplate;
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private MdmDataVersionService mdmDataVersionService;
    public static final String SYNC_DEVICE_CONFIG_KEY_PREFIX = "SYNC_DEVICE_CONFIG_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230ldt\u5e73\u53f0\u63a8\u9001\u76848406\u6d88\u606f:{}", (Object)message);
        MdmDataVersionItem mdmDataVersionItem = null;
        boolean syncResult = false;
        String key = "";
        try {
            SyncDataReq data = (SyncDataReq)JSONObject.parseObject((String)message, SyncDataReq.class);
            String deviceId = data.getDeviceId();
            String orgCode = data.getOrgCode();
            if (Objects.isNull(deviceId) || Objects.isNull(orgCode)) {
                LOGGER.info("deviceId\u6216\u8005orgCode\u4e3a\u7a7a,deviceId:{},orgCode:{}", (Object)deviceId, (Object)orgCode);
                return;
            }
            TExpAutoDevice tExpAutoDevice = this.autoDevice.selectByDeviceIdInCache(deviceId);
            if (Objects.isNull(tExpAutoDevice)) {
                LOGGER.info("\u76d1\u63a7\u7f51\u5173\u672c\u5730\u65e0\u6b64\u8bbe\u5907\u4fe1\u606f,\u8bbe\u5907deviceId:{}", (Object)message);
                return;
            }
            key = SYNC_DEVICE_CONFIG_KEY_PREFIX + deviceId;
            mdmDataVersionItem = this.mdmDataVersionService.acquireMdmVersionLock(key, 30);
            if (mdmDataVersionItem == null) {
                LOGGER.info("\u672a\u83b7\u53d6\u5230\u6570\u636e\u540c\u6b65\u9501\u5bf9\u8c61, key\uff1a" + key);
                LOGGER.info("\u3010----\u914d\u7f6e\u6570\u636e\u540c\u6b65\u7ed3\u675f----\u3011");
                return;
            }
            LOGGER.info("\u83b7\u53d6\u5230\u6570\u636e\u540c\u6b65\u9501\u5bf9\u8c61, key\uff1a" + key);
            LdtDeviceMain ldtDeviceMain = this.ldtDeviceMainService.queryByOrgCodeAndDeviceId(orgCode, deviceId, Integer.valueOf(StatusEnum.ENABLE.getCode()));
            SyncDataResp syncDataResp = new SyncDataResp();
            syncDataResp.setOrgCode(SysPropertiesConfig.getOrgCode());
            syncDataResp.setOrgName(SysPropertiesConfig.getOrgName());
            syncDataResp.setDeviceId(deviceId);
            Long syncTime = data.getSyncTime();
            if (syncTime == null) {
                syncTime = System.currentTimeMillis();
            }
            syncDataResp.setSyncTime(syncTime);
            String sendTopic = "sys/monitor_send/" + SysPropertiesConfig.getOrgCode() + "/visual_config/up_raw";
            if (Objects.isNull(ldtDeviceMain)) {
                String msg = "\u76d1\u63a7\u7f51\u5173\u672c\u5730ldt\u672a\u8fdb\u884c\u8fc7\u5382\u5bb6\u8bbe\u5907\u4fe1\u606f\u540c\u6b65,\u8bbe\u5907deviceId:" + deviceId;
                LOGGER.info(msg);
                syncDataResp.setMessage(msg);
                syncDataResp.setLatticeSectionList(new ArrayList());
                syncDataResp.setLayerList(new ArrayList());
                syncResult = this.emqTemplate.publish(sendTopic, JSONObject.toJSONString((Object)syncDataResp), QoSEnum.QoS0, false);
                if (syncResult) {
                    LOGGER.info("\u914d\u7f6e\u6570\u636e\u540c\u6b65\u4e0a\u4f20\u6210\u529f");
                }
                return;
            }
            Long deviceMainId = ldtDeviceMain.getId();
            Map supplyAreaMap = this.ldtDeviceSupplyService.queryByDeviceMainIdAndLayerNo(deviceMainId, null, Integer.valueOf(StatusEnum.ENABLE.getCode()));
            Map ldtDeviceCarts = this.ldtDeviceCartService.queryByDeviceMainId(deviceMainId, Integer.valueOf(StatusEnum.ENABLE.getCode()));
            if (MapUtils.isEmpty((Map)supplyAreaMap) || MapUtils.isEmpty((Map)ldtDeviceCarts)) {
                LOGGER.info("\u672c\u5730\u4f9b\u4ef6\u533a\u6216\u8005\u5c0f\u8f66\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65.....");
                syncDataResp.setLatticeSectionList(new ArrayList());
                syncDataResp.setLayerList(new ArrayList());
                syncDataResp.setMessage("\u4f9b\u4ef6\u533a\u6216\u8005\u5c0f\u8f66\u4fe1\u606f\u4e3a\u7a7a");
                syncResult = this.emqTemplate.publish(sendTopic, JSONObject.toJSONString((Object)syncDataResp), QoSEnum.QoS0, false);
                if (syncResult) {
                    LOGGER.info("\u914d\u7f6e\u540c\u6b65\u4e0a\u4f20\u6210\u529f(\u65e0\u6570\u636e)");
                }
                return;
            }
            List lattices = this.latticeService.queryByDeviceMainId(deviceMainId, Integer.valueOf(StatusEnum.ENABLE.getCode()));
            List supplyTables = this.supplyTableService.queryByDeviceMainId(deviceMainId, Integer.valueOf(StatusEnum.ENABLE.getCode()));
            syncDataResp.setLatticeNoType(ldtDeviceMain.getLatticeNoType());
            ArrayList layerInfoList = new ArrayList();
            Set supplyAreaEntries = supplyAreaMap.entrySet();
            supplyAreaEntries.forEach(e -> {
                Integer layerNo = (Integer)e.getKey();
                List areas = (List)e.getValue();
                SyncDataResp.LayerInfo layerInfo = new SyncDataResp.LayerInfo();
                layerInfo.setLayerNo(layerNo + "");
                CartDTO ldtDeviceCart = (CartDTO)ldtDeviceCarts.get(layerNo);
                layerInfo.setCartInfo(ldtDeviceCart);
                layerInfo.setSupplyAreaList(areas);
                layerInfoList.add(layerInfo);
            });
            List latticeSectionInfo = this.sectionService.getLatticeSectionInfo(deviceMainId);
            syncDataResp.setLatticeSectionList(latticeSectionInfo);
            syncDataResp.setLayerList(layerInfoList);
            syncDataResp.setLatticeList(lattices);
            syncDataResp.setSupplyTableList(supplyTables);
            syncResult = this.emqTemplate.publish(sendTopic, JSONObject.toJSONString((Object)syncDataResp), QoSEnum.QoS0, false);
            if (syncResult) {
                String msg = "\u914d\u7f6e\u540c\u6b65\u4e0a\u4f20\u6210\u529f(\u6709\u6570\u636e)";
                syncDataResp.setMessage(msg);
                LOGGER.info(msg);
            }
        }
        catch (Exception e2) {
            LOGGER.error("\u914d\u7f6e\u6570\u636e\u540c\u6b65\u51fa\u9519\u4e86...", (Throwable)e2);
        }
        finally {
            if (Objects.nonNull(mdmDataVersionItem)) {
                if (syncResult) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e3) {
                        LOGGER.error("\u914d\u7f6e\u6570\u636e\u540c\u6b65\u65f6,\u7ebf\u7a0b\u4f11\u7720\u51fa\u73b0\u5f02\u5e38...", (Throwable)e3);
                    }
                }
                if (ExpUtils.isNotBlank((String)key)) {
                    this.mdmDataVersionService.releaseMdmVersionLock(key);
                }
                LOGGER.info("\u3010----\u914d\u7f6e\u6570\u636e\u540c\u6b65\u7ed3\u675f----\u3011");
            }
        }
    }
}

