/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.entity.ManageConfigResp;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.CfgService;
import com.yto.monitor.adapter.service.ManageConfigService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.ExpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@MqttMsg(topic="8408")
public class Mqtt8408ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    public static String USED_N = "0";
    @Autowired
    private CfgService cfgService;
    @Autowired
    private ManageConfigService manageConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u7684\u914d\u7f6e8408\u6d88\u606f:{}", (Object)message);
        boolean needTriggerRefresh = false;
        try {
            String orgCode;
            if (ExpUtils.isBlank((String)message)) {
                return;
            }
            ManageConfigResp manageConfigResp = (ManageConfigResp)JSONObject.parseObject((String)message, ManageConfigResp.class);
            if (ExpUtils.isBlank((String)manageConfigResp.getUsed()) || Objects.isNull(manageConfigResp.getConfigType())) {
                LOGGER.info("\u6536\u5230\u7684\u6d88\u606f\u72b6\u6001\u6807\u8bc6\u6216\u5220\u9664\u6807\u8bc6\u4e3a\u7a7a,\u975e\u6cd5\u6570\u636e\u6682\u4e0d\u5904\u7406:{}", (Object)message);
                return;
            }
            Integer configType = manageConfigResp.getConfigType();
            List excludeOrgCodes = manageConfigResp.getExcludeOrgCodes();
            if (!CollectionUtils.isEmpty((Collection)excludeOrgCodes) && excludeOrgCodes.contains(orgCode = SysPropertiesConfig.getOrgCode())) {
                LOGGER.info("{}\u5728\u6392\u9664\u7684\u7ec4\u7ec7\u8303\u56f4\u5185,\u4e0d\u8fdb\u884c\u5904\u7406", (Object)orgCode);
                return;
            }
            if (USED_N.equals(manageConfigResp.getUsed())) {
                CfgService.MANAGE_CONFIG_TYPE_MAP.remove(configType);
                this.cfgService.refreshClientConfigParam();
                needTriggerRefresh = true;
                return;
            }
            CfgService.MANAGE_CONFIG_TYPE_MAP.put(configType, manageConfigResp);
            this.cfgService.refreshClientConfigParam();
            needTriggerRefresh = true;
        }
        catch (Exception e) {
            LOGGER.info("\u5904\u7406\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848408\u6d88\u606f:{},\u51fa\u73b0\u5f02\u5e38:{}", (Object)message, (Object)e.getMessage());
        }
        finally {
            if (needTriggerRefresh) {
                this.manageConfigService.triggerRefreshAction();
            }
        }
    }
}

