/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.mqtt.ManageEmpResp;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.IExpEmployeeService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.entity.base.Employee;
import com.yto.monitor.common.util.ExpUtils;
import java.io.Serializable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="8410")
public class Mqtt8410ServiceImpl
implements MqttMsgService<String> {
    private static final Logger logger = CustomLoggerFactory.MqttLogger();
    @Autowired
    private IExpEmployeeService expEmployeeService;

    public void onMessage(String message) {
        try {
            logger.info("\u6536\u5230\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u7684\u914d\u7f6e8410\u6d88\u606f:{}", (Object)message);
            if (ExpUtils.isBlank((String)message)) {
                return;
            }
            ManageEmpResp empResp = (ManageEmpResp)JSONObject.parseObject((String)message, ManageEmpResp.class);
            if (empResp == null || ExpUtils.isBlank((String)empResp.getUserCode())) {
                logger.info("\u6536\u5230\u7684\u5458\u5de5\u53d8\u66f4\u6d88\u606f\u4e3a\u7a7a,\u975e\u6cd5\u6570\u636e\u6682\u4e0d\u5904\u7406:{}", (Object)message);
                return;
            }
            String empCode = empResp.getUserCode();
            Employee employee = this.expEmployeeService.getEmployeeByCode(empCode);
            if (employee == null) {
                logger.info("\u67e5\u8be2\u5458\u5de5\u53d8\u66f4\u7684\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a:{}", (Object)empCode);
                return;
            }
            if ("dimission".equals(empResp.getChangeType())) {
                this.expEmployeeService.removeById((Serializable)((Object)employee.getId()));
                logger.info("\u5220\u9664\u5458\u5de5\u79bb\u804c\u540e\u7684\u65e0\u6548\u7ec4\u7ec7\u5458\u5de5\u6570\u636e:{}", (Object)empCode);
            } else if ("changeOrg".equals(empResp.getChangeType()) && !employee.getBelongOrg().equals(empResp.getAfterData())) {
                this.expEmployeeService.removeById((Serializable)((Object)employee.getId()));
                logger.info("\u5220\u9664\u5458\u5de5\u53d8\u66f4\u540e\u7684\u65e0\u6548\u7ec4\u7ec7\u5458\u5de5\u6570\u636e:{}", (Object)empCode);
            }
        }
        catch (Exception e) {
            logger.info("\u5904\u7406\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u76848410\u914d\u7f6e\u6d88\u606f:{},\u51fa\u73b0\u5f02\u5e38:{}", (Object)message, (Object)e.getMessage());
        }
    }
}

