/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.MQTTMessage;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.mqtt.properties.MqttConfigProperties;
import com.yto.monitor.adapter.service.CalibrateScaleRecordService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="9401")
public class Mqtt9401ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private CalibrateScaleRecordService calibrateScaleRecordService;
    @Autowired
    private MqttConfigProperties mqttConfigProperties;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u9a7e\u9a76\u8231\u63a8\u9001\u7684\u6821\u79f0\u786e\u8ba4\u6d88\u606f:{}", (Object)message);
        try {
            MQTTMessage.CorrelationData data = (MQTTMessage.CorrelationData)JSONObject.parseObject((String)message, MQTTMessage.CorrelationData.class);
            if (Objects.isNull(data) || Objects.isNull(this.mqttConfigProperties.getClientId())) {
                return;
            }
            String clientId = data.getClientId();
            String dataId = data.getDataId();
            if (Objects.isNull(clientId) || Objects.isNull(dataId)) {
                return;
            }
            if (clientId.equals(this.mqttConfigProperties.getClientId())) {
                LOGGER.info("\u7531mqtt\u5ba2\u6237\u7aef:{}\u5904\u7406\u6d88\u606f,dataId:{}", (Object)clientId, (Object)dataId);
                this.calibrateScaleRecordService.handleSuccessResponse(Long.parseLong(dataId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9a7e\u9a76\u8231\u63a8\u9001\u7684\u6821\u79f0\u786e\u8ba4\u6d88\u606f:{},\u51fa\u73b0\u5f02\u5e38:{}", new Object[]{message, e.getMessage(), e});
        }
    }
}

