/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yto.monitor.adapter.entity.MdmDataVersionItem;
import com.yto.monitor.adapter.entity.SchemePermissionAssignment;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.SchemePermissionAssignmentService;
import com.yto.monitor.adapter.service.download.MdmDataVersionService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@MqttMsg(topic="9403")
public class Mqtt9403ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private MdmDataVersionService mdmDataVersionService;
    @Autowired
    private SchemePermissionAssignmentService schemePermissionAssignmentService;
    private static final String LOCK = "MPUSH_LATTICE_SCHEME_PERMISSION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        MdmDataVersionItem mdmDataVersionItem = null;
        mdmDataVersionItem = this.mdmDataVersionService.acquireMdmVersionLock(LOCK, 30);
        if (mdmDataVersionItem == null) {
            LOGGER.info("\u683c\u53e3\u6743\u9650\u63a8\u9001\u672a\u83b7\u53d6\u5230\u9501\u5bf9\u8c61, key\uff1aMPUSH_LATTICE_SCHEME_PERMISSION");
            return;
        }
        try {
            LOGGER.info("\u6536\u5230\u683c\u53e3\u6743\u9650\u63a8\u9001\u6570\u636e {}", (Object)message);
            if (StringUtils.isBlank((String)message)) {
                return;
            }
            List list = (List)JSONObject.parseObject((String)message, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            for (SchemePermissionAssignment assignment : list) {
                this.schemePermissionAssignmentService.removeById((Serializable)assignment.getId());
                if (assignment.getDeleted() != null && assignment.getDeleted().booleanValue()) continue;
                this.schemePermissionAssignmentService.save((Object)assignment);
            }
        }
        finally {
            this.mdmDataVersionService.releaseMdmVersionLock(LOCK);
        }
    }
}

