/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.MdmDataVersionItem;
import com.yto.monitor.adapter.mapper.ExpSsiContrabandMapper;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.download.MdmDataVersionService;
import com.yto.monitor.adapter.service.ssi.SsiCmdPushService;
import com.yto.monitor.adapter.ssi.entity.SsiContraband;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.MtyEnum;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="9404")
public class Mqtt9404ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private MdmDataVersionService mdmDataVersionService;
    @Autowired
    private ExpSsiContrabandMapper ssiContrabandMapper;
    @Autowired
    private SsiCmdPushService ssiCmdPushService;
    private static final String LOCK = "MPUSH_SSI_CONTRABAND";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        MdmDataVersionItem mdmDataVersionItem = null;
        mdmDataVersionItem = this.mdmDataVersionService.acquireMdmVersionLock(LOCK, 30);
        if (mdmDataVersionItem == null) {
            LOGGER.info("\u8fdd\u7981\u54c1\u914d\u7f6e\u63a8\u9001\u672a\u83b7\u53d6\u5230\u9501\u5bf9\u8c61, key\uff1aMPUSH_SSI_CONTRABAND");
            return;
        }
        try {
            LOGGER.info("\u6536\u5230\u8fdd\u7981\u54c1\u914d\u7f6e\u63a8\u9001\u6570\u636e {}", (Object)message);
            if (StringUtils.isBlank((String)message)) {
                return;
            }
            SsiContraband ssiContraband = (SsiContraband)JSONObject.parseObject((String)message, SsiContraband.class);
            this.ssiContrabandMapper.deleteById((Serializable)ssiContraband);
            if (!ssiContraband.getIsDelete().booleanValue()) {
                this.ssiContrabandMapper.insert((Object)ssiContraband);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mty", (Object)MtyEnum.MTY_SSI_PUSH_CMD.getMty());
            List contrabandList = this.ssiContrabandMapper.getContrabandList();
            jsonObject.put("categoryList", (Object)contrabandList);
            this.ssiCmdPushService.cmdPush(jsonObject, null);
        }
        finally {
            this.mdmDataVersionService.releaseMdmVersionLock(LOCK);
        }
    }
}

