/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.message.service;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.entity.mqtt.SsiCommandMsg;
import com.yto.monitor.adapter.mqtt.message.listener.MqttMsg;
import com.yto.monitor.adapter.mqtt.message.service.MqttMsgService;
import com.yto.monitor.adapter.service.ssi.SsiCmdPushService;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.constant.MtyEnum;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MqttMsg(topic="9405")
public class Mqtt9405ServiceImpl
implements MqttMsgService<String> {
    private static final Logger LOGGER = CustomLoggerFactory.MqttLogger();
    @Autowired
    private SsiCmdPushService ssiCmdPushService;

    public void onMessage(String message) {
        LOGGER.info("\u6536\u5230\u5b89\u68c0\u673a\u547d\u4ee4\u63a8\u9001 {}", (Object)message);
        if (StringUtils.isBlank((String)message)) {
            return;
        }
        SsiCommandMsg commandMsg = (SsiCommandMsg)JSONObject.parseObject((String)message, SsiCommandMsg.class);
        if (SsiCommandMsg.COMMAND_SSI_LOGOUT.equals(commandMsg.getCommand())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mty", (Object)MtyEnum.MTY_SSI_PUSH_CMD.getMty());
            jsonObject.put("extend1", (Object)"1");
            this.ssiCmdPushService.cmdPush(jsonObject, commandMsg.getDeviceNos());
        }
    }
}

