/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.properties;

import com.yto.monitor.adapter.constant.OrgTypeEnum;
import com.yto.monitor.adapter.security.crypto.AutoSignature;
import com.yto.monitor.adapter.security.crypto.Tuple2;
import com.yto.monitor.adapter.utils.CommonUtils;
import com.yto.monitor.adapter.utils.SignUtil;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.ExpUtils;
import com.yto.monitor.common.util.TerminalNetUtil;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import org.slf4j.Logger;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mqtt")
public class MqttConfigProperties {
    private String brokerUrl;
    private String clientId;
    private String username;
    private String password;
    private String[] subscribeTopics;
    private int[] qos;
    public static final String TOPIC_PREFIX = "sys/monitor";
    public static final String ALL_ORGCODE = "999999";
    public static final String ALL_BRANCH = "branch";
    public static final String ALL_CENTER = "center";
    private static final Logger logger = CustomLoggerFactory.MqttLogger();

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getSubscribeTopics() {
        return this.subscribeTopics;
    }

    public void setSubscribeTopics(String[] subscribeTopics) {
        this.subscribeTopics = subscribeTopics;
    }

    public int[] getQos() {
        return this.qos;
    }

    public void setQos(int[] qos) {
        this.qos = qos;
    }

    public void assembleProp(String serverPort, String orgCode, String orgType, String secret, String version) {
        String ipPort = "";
        InetAddress localHostLANAddress = CommonUtils.getLocalHostLANAddress();
        ipPort = Objects.nonNull(localHostLANAddress) ? localHostLANAddress.getHostAddress() + ":" + serverPort : TerminalNetUtil.mulNetworkLocalIp + ":" + serverPort;
        Random random = new Random();
        int seq = random.nextInt(90) + 10;
        long timestamp = System.currentTimeMillis();
        Long appId = AutoSignature.INSTANCE.getAppId(secret);
        this.clientId = ipPort + "|orgcode=" + orgCode + ",seq=" + seq + ",platform=monitor,version=" + version + ",timestamp=" + timestamp + "|";
        if (Objects.nonNull(appId)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("timestamp", String.valueOf(timestamp));
            params.put("orgcode", orgCode);
            params.put("appid", String.valueOf(appId));
            Tuple2 tuple2 = SignUtil.getSignature(params, (String)secret);
            if (Objects.nonNull(tuple2)) {
                this.password = (String)tuple2.key;
                this.username = appId + "&" + orgCode + "&monitor";
            }
        }
        String topic = "sys/monitor/" + orgCode + "/#";
        String wholeTopic = "sys/monitor/999999/#";
        String subTopic = "";
        if (OrgTypeEnum.TRANSFER_CENTER.name().equals(orgType)) {
            subTopic = "sys/monitor/center/#";
        }
        if (OrgTypeEnum.BRANCH.name().equals(orgType)) {
            subTopic = "sys/monitor/branch/#";
        }
        if (ExpUtils.isNotBlank((String)subTopic)) {
            this.setSubscribeTopics(new String[]{topic, wholeTopic, subTopic});
        } else {
            this.setSubscribeTopics(new String[]{topic, wholeTopic});
        }
        String[] subscribeTopics = this.getSubscribeTopics();
        this.qos = new int[subscribeTopics.length];
        for (int i = 0; i < subscribeTopics.length; ++i) {
            this.qos[i] = 2;
        }
        logger.info("\u5f53\u524dmqtt\u7684clientId:{},username:{},version:{}", new Object[]{this.clientId, this.username, version});
    }
}

