/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.subscribe;

import com.yto.monitor.adapter.mqtt.client.EmqTemplate;
import com.yto.monitor.adapter.mqtt.event.MqttSubscribeEvent;
import com.yto.monitor.adapter.mqtt.properties.MqttConfigProperties;
import com.yto.monitor.adapter.mqtt.support.MqttContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class MqttSubscribeListener
implements ApplicationListener<MqttSubscribeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttSubscribeListener.class);
    private EmqTemplate emqTemplate;
    private MqttConfigProperties properties;

    public void setEmqTemplate(EmqTemplate emqTemplate) {
        this.emqTemplate = emqTemplate;
    }

    public void setProperties(MqttConfigProperties properties) {
        this.properties = properties;
    }

    public void onApplicationEvent(MqttSubscribeEvent event) {
        if (event.getSource() instanceof MqttContainer) {
            MqttContainer mqttContainer = (MqttContainer)event.getSource();
            this.emqTemplate.setMqttClient(mqttContainer.getMqttClient());
        }
        this.emqTemplate.subscribe(this.properties.getSubscribeTopics(), this.properties.getQos());
    }
}

