/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.mqtt.support;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.yto.monitor.adapter.mqtt.client.MqttMessageCallback;
import com.yto.monitor.adapter.mqtt.event.MqttConnectionCloseEvent;
import com.yto.monitor.adapter.mqtt.event.MqttConnectionConnectEvent;
import com.yto.monitor.adapter.mqtt.event.MqttEventBus;
import com.yto.monitor.adapter.mqtt.event.MqttSubscribeEvent;
import com.yto.monitor.adapter.mqtt.properties.MqttConfigProperties;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;

public class MqttContainer
implements InitializingBean,
SmartLifecycle,
ApplicationContextAware,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttContainer.class);
    private volatile boolean running;
    private ApplicationContext applicationContext;
    private IMqttClient mqttClient;
    private MqttConfigProperties properties;
    private MqttCallback mqttCallback;

    public MqttContainer(MqttConfigProperties properties) {
        this.properties = properties;
    }

    public MqttConfigProperties getProperties() {
        return this.properties;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.disConnect();
            this.setRunning(false);
        }
        LOGGER.info("container destroyed, {}", (Object)this.toString());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.init();
        }
        catch (MqttException e) {
            LOGGER.error("init mqtt client error,errormsg={},brokerUrl={},clientId={}", new Object[]{e.getMessage(), this.properties.getBrokerUrl(), this.properties.getClientId()});
            return;
        }
        boolean conn = this.connect(this.properties.getUsername(), this.properties.getPassword());
        if (conn) {
            LOGGER.info("running container: {}", (Object)this.toString());
        } else {
            this.reConnect();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.disConnect();
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public IMqttClient getMqttClient() {
        return this.mqttClient;
    }

    public void setMqttClient(IMqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    private void init() throws MqttException {
        MqttEventBus.register((Object)this);
        this.mqttCallback = new MqttMessageCallback();
        MemoryPersistence mempersitence = new MemoryPersistence();
        this.mqttClient = new MqttClient(this.properties.getBrokerUrl(), this.properties.getClientId(), (MqttClientPersistence)mempersitence);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(MqttConnectionCloseEvent event) {
        this.reConnect();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(MqttConnectionConnectEvent event) {
        this.setRunning(true);
        LOGGER.info("begin to subscribe...");
        this.applicationContext.publishEvent((ApplicationEvent)new MqttSubscribeEvent(this));
    }

    private boolean connect(String username, String password) {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setUserName(username);
        options.setPassword(password.toCharArray());
        options.setCleanSession(true);
        this.mqttClient.setCallback(this.mqttCallback);
        try {
            this.mqttClient.connect(options);
            return true;
        }
        catch (MqttException e) {
            LOGGER.error("mqtt client connect broker fail,message={}", (Object)e.getMessage());
            return false;
        }
    }

    private void disConnect() {
        try {
            LOGGER.info("mqtt client disconnect...");
            this.mqttClient.disconnect();
        }
        catch (MqttException e) {
            LOGGER.error("mqtt client disconnect broker fail,message={}", (Object)e.getMessage());
        }
    }

    private void reConnect() {
        try {
            LOGGER.info("mqtt client reconnect...");
            this.mqttClient.reconnect();
        }
        catch (MqttException e) {
            LOGGER.error("mqtt client reconnect broker fail,message={}", (Object)e.getMessage());
        }
    }
}

