/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.schedule;

import com.yto.monitor.adapter.schedule.BaseJob;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.util.ExpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class SchedulerJobManager
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerJobManager.class);
    private static final Logger sysLogger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    private ApplicationContext applicationContext;
    public static Map<String, CronTrigger> cronTriggerMap = new HashMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void scheduleAllJobs() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        this.scheduleJobs(scheduler);
    }

    public void stop() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        scheduler.clear();
    }

    private void scheduleJobs(Scheduler scheduler) throws SchedulerException {
        Map jobMap = this.applicationContext.getBeansOfType(BaseJob.class);
        for (BaseJob job : jobMap.values()) {
            try {
                String jobName = job.getClass().getSimpleName() + "_job";
                String jobTriggerName = job.getClass().getSimpleName() + "_trigger";
                String jobGroupName = job.getClass().getSimpleName() + "_group";
                JobDetail jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(jobName, jobGroupName).build();
                String cronExpression = job.getCronExpression();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobTriggerName, jobGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                JobKey jobKey = new JobKey(jobName, jobGroupName);
                TriggerKey triggerKey = new TriggerKey(jobTriggerName, jobGroupName);
                if (scheduler.checkExists(jobKey) || scheduler.checkExists(triggerKey)) continue;
                logger.info("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\uff1a" + jobName);
                scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                if (!job.refresh()) continue;
                cronTriggerMap.put(job.getClass().getSimpleName(), trigger);
            }
            catch (Exception f) {
                logger.error("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\u4e86: " + f);
            }
        }
    }

    public void reScheduleJob(String jobName, String newCronExpression) throws Exception {
        CronTrigger oldTrigger = (CronTrigger)cronTriggerMap.get(jobName);
        if (Objects.isNull(oldTrigger) || ExpUtils.isBlank((String)oldTrigger.getCronExpression())) {
            return;
        }
        if (oldTrigger.getCronExpression().equals(newCronExpression)) {
            return;
        }
        CronTrigger newTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(oldTrigger.getKey().getName(), oldTrigger.getKey().getGroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)newCronExpression)).build();
        sysLogger.info("jobName:{} \u7531\u539f\u8868\u8fbe\u5f0f{} \u5207\u6362\u6210\u8868\u8fbe\u5f0f{}", new Object[]{jobName, oldTrigger.getCronExpression(), newCronExpression});
        this.schedulerFactoryBean.getScheduler().rescheduleJob(oldTrigger.getKey(), (Trigger)newTrigger);
        cronTriggerMap.put(jobName, newTrigger);
    }
}

