/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.security.crypto;

import com.yto.monitor.adapter.security.AutomaticApiException;
import com.yto.monitor.adapter.security.crypto.AESUtils;
import com.yto.monitor.adapter.security.crypto.Base64Utils;
import com.yto.monitor.adapter.security.crypto.CryptoException;
import com.yto.monitor.adapter.security.crypto.Pair;
import com.yto.monitor.adapter.security.crypto.RSAUtils;
import com.yto.monitor.adapter.security.crypto.SequenceIdGenerator;
import com.yto.monitor.adapter.security.crypto.Tuple2;
import com.yto.monitor.adapter.security.crypto.Tuple4;
import com.yto.monitor.adapter.security.util.AlipaySignature;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AutoSignature {
    INSTANCE;

    private static final Logger LOGGER;
    public static final int RAS_KEY_SIZE = 2048;
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_ALGORITHM_PADDING = "RSA/ECB/PKCS1Padding";
    private static final int MAX_DECRYPT_BLOCK = 256;
    private static final int MAX_ENCRYPT_BLOCK = 244;

    private String getInvokeMethod() {
        return "findLoadedClass";
    }

    private String getClassLoaderName() {
        return "sun.misc.Launcher$AppClassLoader";
    }

    private List<String> getInvokes() {
        List<String> invokes = Arrays.asList("com.yto.exp.busigateway.Application", "com.yto.monitor.adapter.AdapterApplication", "com.yto.monitor.web.Application", "cn.yto.MainApplication", "com.yto.express.Application", "cn.yto.automatic.undm.AutomaticUndmWebApplication");
        return invokes;
    }

    private void check() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!classLoader.getClass().getName().equals(this.getClassLoaderName())) {
                throw new AutomaticApiException("Instantiation failed");
            }
            Class<?> classLoaderClass = classLoader.getClass().getSuperclass().getSuperclass().getSuperclass();
            Method method = classLoaderClass.getDeclaredMethod(this.getInvokeMethod(), String.class);
            method.setAccessible(true);
            List invokes = this.getInvokes();
            for (String invoke : invokes) {
                Object obj = method.invoke((Object)classLoader, invoke);
                if (obj == null) continue;
                return;
            }
            throw new AutomaticApiException("Instantiation failed");
        }
        catch (Exception e) {
            throw new AutomaticApiException("Instantiation failed");
        }
    }

    public Tuple4<Long, String, String, String> genKeyAndSecret() throws Exception {
        Long appid = SequenceIdGenerator.nextId();
        Pair pair = RSAUtils.genKeyPair((int)2048);
        RSAPublicKey publicKey = (RSAPublicKey)pair.key;
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.value;
        StringBuilder sb = new StringBuilder();
        sb.append(appid);
        sb.append("&");
        sb.append(this.encodeBase64((Key)privateKey));
        byte[] data = AESUtils.encrypt((byte[])sb.toString().getBytes("UTF-8"), (byte[])AESUtils.getKey().getBytes("UTF-8"), (byte[])AESUtils.getIv().getBytes("UTF-8"));
        return Tuple4.of((Object)appid, (Object)this.encodeBase64((Key)publicKey), (Object)this.encodeBase64((Key)privateKey), (Object)Base64Utils.encode((byte[])data));
    }

    public Tuple4<Long, String, String, String> genKeyAndSecret(Long appid) throws Exception {
        Pair pair = RSAUtils.genKeyPair((int)2048);
        RSAPublicKey publicKey = (RSAPublicKey)pair.key;
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.value;
        StringBuilder sb = new StringBuilder();
        sb.append(appid);
        sb.append("&");
        sb.append(this.encodeBase64((Key)privateKey));
        byte[] data = AESUtils.encrypt((byte[])sb.toString().getBytes("UTF-8"), (byte[])AESUtils.getKey().getBytes("UTF-8"), (byte[])AESUtils.getIv().getBytes("UTF-8"));
        return Tuple4.of((Object)appid, (Object)this.encodeBase64((Key)publicKey), (Object)this.encodeBase64((Key)privateKey), (Object)Base64Utils.encode((byte[])data));
    }

    public Pair<String, String> genKey() throws Exception {
        Pair pair = RSAUtils.genKeyPair((int)2048);
        RSAPublicKey publicKey = (RSAPublicKey)pair.key;
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.value;
        return Pair.of((Object)this.encodeBase64((Key)publicKey), (Object)this.encodeBase64((Key)privateKey));
    }

    public Pair<RSAPublicKey, RSAPrivateKey> genKeyPair(int rsaKeySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(rsaKeySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            return Pair.of((Object)publicKey, (Object)privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getKeys ex ", (Throwable)e);
            return null;
        }
    }

    public String encodeBase64(Key key) throws Exception {
        return Base64Utils.encode((byte[])key.getEncoded());
    }

    public PrivateKey decodePrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decode((String)key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public PublicKey decodePublicKey(String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePublic(x509KeySpec);
    }

    public Tuple2<Long, String> sign(Map<String, String> params, String secret) {
        try {
            byte[] data = AESUtils.decrypt((byte[])Base64Utils.decode((String)secret), (byte[])AESUtils.getKey().getBytes("UTF-8"), (byte[])AESUtils.getIv().getBytes("UTF-8"));
            String decryptData = new String(data);
            String[] appidAndSecret = decryptData.split("&");
            Long appid = Long.valueOf(appidAndSecret[0]);
            String privateKey = appidAndSecret[1];
            return Tuple2.of((Object)appid, (Object)AlipaySignature.sign(params, (String)privateKey, (String)"UTF-8", (String)"RSA2"));
        }
        catch (Exception ex) {
            LOGGER.error("error generating signature...", (Throwable)ex);
            return null;
        }
    }

    public Long getAppId(String secret) {
        try {
            byte[] data = AESUtils.decrypt((byte[])Base64Utils.decode((String)secret), (byte[])AESUtils.getKey().getBytes("UTF-8"), (byte[])AESUtils.getIv().getBytes("UTF-8"));
            String decryptData = new String(data);
            String[] appidAndSecret = decryptData.split("&");
            return Long.valueOf(appidAndSecret[0]);
        }
        catch (Exception ex) {
            LOGGER.error("error get AppId...", (Throwable)ex);
            return null;
        }
    }

    public boolean verify(Map<String, String> params, String publicKey) {
        try {
            return AlipaySignature.verifyV1(params, (String)publicKey, (String)"UTF-8", (String)"RSA2");
        }
        catch (Exception ex) {
            LOGGER.error("error verifying signature...", (Throwable)ex);
            return false;
        }
    }

    public boolean verify(Map<String, String> params, String publicKey, String sign) {
        try {
            if (params == null || params.isEmpty()) {
                return false;
            }
            params.put("sign", sign);
            return AlipaySignature.verifyV1(params, (String)publicKey, (String)"UTF-8", (String)"RSA2");
        }
        catch (Exception ex) {
            LOGGER.error("error verifying signature...", (Throwable)ex);
            return false;
        }
    }

    public RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LOGGER.error("getPublicKey ex modulus={}, exponent={}", new Object[]{modulus, exponent, e});
            throw new CryptoException("Get PublicKey ex", (Throwable)e);
        }
    }

    public RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            LOGGER.error("getPrivateKey ex modulus={}, exponent={}", new Object[]{modulus, exponent, e});
            throw new CryptoException("Get PrivateKey ex", (Throwable)e);
        }
    }

    public byte[] encryptByPublicKey(byte[] data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(1, publicKey);
            int key_len = publicKey.getModulus().bitLength() / 8;
            return this.doFinal(cipher, data, key_len - 11);
        }
        catch (Exception e) {
            LOGGER.error("encryptByPublicKey ex", (Throwable)e);
            throw new CryptoException("RSA encrypt ex", (Throwable)e);
        }
    }

    public byte[] decryptByPrivateKey(byte[] data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(2, privateKey);
            int key_len = privateKey.getModulus().bitLength() / 8;
            return this.doFinal(cipher, data, key_len);
        }
        catch (Exception e) {
            LOGGER.error("decryptByPrivateKey ex", (Throwable)e);
            throw new CryptoException("RSA decrypt ex", (Throwable)e);
        }
    }

    private byte[] doFinal(Cipher cipher, byte[] data, int key_len) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen;
        int offset = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.getTmpArrayLength(inputLen));
        for (inputLen = data.length; inputLen > 0; inputLen -= key_len) {
            byte[] tmp = cipher.doFinal(data, offset, Math.min(key_len, inputLen));
            out.write(tmp, 0, tmp.length);
            offset += key_len;
        }
        return out.toByteArray();
    }

    private int getTmpArrayLength(int L) {
        int S;
        for (S = 256; S < L; S <<= 1) {
        }
        return S;
    }

    public byte[] decryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = this.decodePrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(2, key);
        return this.doFinal(cipher, data, 256);
    }

    public byte[] decryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = this.decodePublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(2, key);
        return this.doFinal(cipher, data, 256);
    }

    public byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = this.decodePublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(1, key);
        return this.doFinal(cipher, data, 244);
    }

    public byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = this.decodePrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(1, key);
        return this.doFinal(cipher, data, 244);
    }

    static {
        LOGGER = LoggerFactory.getLogger(AutoSignature.class);
    }
}

