/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.security.crypto;

import com.yto.monitor.adapter.security.crypto.Base64Utils;
import com.yto.monitor.adapter.security.crypto.CryptoException;
import com.yto.monitor.adapter.security.crypto.Pair;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    public static final int RAS_KEY_SIZE = 1024;
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_ALGORITHM_PADDING = "RSA/ECB/PKCS1Padding";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final int MAX_ENCRYPT_BLOCK = 117;

    public static Pair<RSAPublicKey, RSAPrivateKey> genKeyPair(int rsaKeySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(rsaKeySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            return Pair.of((Object)publicKey, (Object)privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getKeys ex ", (Throwable)e);
            return null;
        }
    }

    public static String encodeBase64(Key key) throws Exception {
        return Base64Utils.encode((byte[])key.getEncoded());
    }

    public static PrivateKey decodePrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decode((String)key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PublicKey decodePublicKey(String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509KeySpec);
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(RSAUtils.decodePrivateKey((String)privateKey));
        signature.update(data);
        return Base64Utils.encode((byte[])signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(RSAUtils.decodePublicKey((String)publicKey));
        signature.update(data);
        return signature.verify(Base64Utils.decode((String)sign));
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LOGGER.error("getPublicKey ex modulus={}, exponent={}", new Object[]{modulus, exponent, e});
            throw new CryptoException("Get PublicKey ex", (Throwable)e);
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            LOGGER.error("getPrivateKey ex modulus={}, exponent={}", new Object[]{modulus, exponent, e});
            throw new CryptoException("Get PrivateKey ex", (Throwable)e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            int key_len = publicKey.getModulus().bitLength() / 8;
            return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)(key_len - 11));
        }
        catch (Exception e) {
            LOGGER.error("encryptByPublicKey ex", (Throwable)e);
            throw new CryptoException("RSA encrypt ex", (Throwable)e);
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            int key_len = privateKey.getModulus().bitLength() / 8;
            return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)key_len);
        }
        catch (Exception e) {
            LOGGER.error("decryptByPrivateKey ex", (Throwable)e);
            throw new CryptoException("RSA decrypt ex", (Throwable)e);
        }
    }

    private static byte[] doFinal(Cipher cipher, byte[] data, int key_len) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen;
        int offset = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(RSAUtils.getTmpArrayLength((int)inputLen));
        for (inputLen = data.length; inputLen > 0; inputLen -= key_len) {
            byte[] tmp = cipher.doFinal(data, offset, Math.min(key_len, inputLen));
            out.write(tmp, 0, tmp.length);
            offset += key_len;
        }
        return out.toByteArray();
    }

    private static int getTmpArrayLength(int L) {
        int S;
        for (S = 128; S < L; S <<= 1) {
        }
        return S;
    }

    public static byte[] decryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = RSAUtils.decodePrivateKey((String)privateKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)128);
    }

    public static byte[] decryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = RSAUtils.decodePublicKey((String)publicKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)128);
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = RSAUtils.decodePublicKey((String)publicKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)117);
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = RSAUtils.decodePrivateKey((String)privateKey);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return RSAUtils.doFinal((Cipher)cipher, (byte[])data, (int)117);
    }

    private static void test() {
        Pair pair = RSAUtils.genKeyPair((int)1024);
        RSAPublicKey publicKey = (RSAPublicKey)pair.key;
        RSAPrivateKey privateKey = (RSAPrivateKey)pair.value;
        String modulus = publicKey.getModulus().toString();
        String public_exponent = publicKey.getPublicExponent().toString();
        String private_exponent = privateKey.getPrivateExponent().toString();
        byte[] ming = "123456789".getBytes(StandardCharsets.UTF_8);
        System.out.println("\u660e\u6587\uff1a" + new String(ming, StandardCharsets.UTF_8));
        RSAPrivateKey priKey = RSAUtils.getPrivateKey((String)modulus, (String)private_exponent);
        RSAPublicKey pubKey = RSAUtils.getPublicKey((String)modulus, (String)public_exponent);
        System.out.println("privateKey=" + priKey);
        System.out.println("publicKey=" + pubKey);
        byte[] mi = RSAUtils.encryptByPublicKey((byte[])ming, (RSAPublicKey)pubKey);
        System.out.println("\u5bc6\u6587\uff1a" + new String(mi, StandardCharsets.UTF_8));
        ming = RSAUtils.decryptByPrivateKey((byte[])mi, (RSAPrivateKey)priKey);
        System.out.println("\u89e3\u5bc6\uff1a" + new String(ming, StandardCharsets.UTF_8));
    }
}

