/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.security.crypto;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SequenceIdGenerator {
    private static final AtomicInteger counter = new AtomicInteger(new SecureRandom().nextInt());
    private static final int TOTAL_BITS = 64;
    private static final int EPOCH_BITS = 42;
    private static final int MACHINE_ID_BITS = 10;
    private static final int MACHINE_ID = SequenceIdGenerator.createMachineId();
    private static final int LOWER_ORDER_TEN_BITS = 1023;
    private static final int LOWER_ORDER_TWELVE_BITS = 4095;

    public static long nextId() {
        long curMs = Instant.now().toEpochMilli();
        long id = curMs << 22;
        id |= (long)(MACHINE_ID << 12);
        return id |= (long)(SequenceIdGenerator.getNextCounter() & 0xFFF);
    }

    private static int getNextCounter() {
        return counter.getAndIncrement();
    }

    private static int createMachineId() {
        int machineId;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X", mac[i]));
                }
            }
            machineId = sb.toString().hashCode();
        }
        catch (Exception ex) {
            machineId = new SecureRandom().nextInt();
        }
        return machineId &= 0x3FF;
    }
}

